package zio.aws.cognitoidentity.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{PaginationKey, QueryLimit}
import scala.jdk.CollectionConverters.*
final case class ListIdentityPoolsRequest(
    maxResults: QueryLimit,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest = {
    import ListIdentityPoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
      .builder()
      .maxResults(QueryLimit.unwrap(maxResults): Integer)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.ReadOnly =
    zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.wrap(buildAwsValue())
}
object ListIdentityPoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListIdentityPoolsRequest =
      zio.aws.cognitoidentity.model
        .ListIdentityPoolsRequest(maxResults, nextToken.map(value => value))
    def maxResults: QueryLimit
    def nextToken: Option[PaginationKey]
    def getMaxResults: ZIO[Any, Nothing, QueryLimit] = ZIO.succeed(maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
  ) extends zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.ReadOnly {
    override val maxResults: QueryLimit =
      zio.aws.cognitoidentity.model.primitives.QueryLimit(impl.maxResults())
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest
  ): zio.aws.cognitoidentity.model.ListIdentityPoolsRequest.ReadOnly =
    new Wrapper(impl)
}
