package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  PrincipalTagID,
  PrincipalTagValue,
  UseDefaults,
  IdentityPoolId,
  IdentityProviderName
}
import scala.jdk.CollectionConverters.*
final case class GetPrincipalTagAttributeMapResponse(
    identityPoolId: Option[IdentityPoolId] = None,
    identityProviderName: Option[IdentityProviderName] = None,
    useDefaults: Option[UseDefaults] = None,
    principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse = {
    import GetPrincipalTagAttributeMapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        identityProviderName.map(value =>
          IdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.identityProviderName)
      .optionallyWith(
        useDefaults.map(value => UseDefaults.unwrap(value): java.lang.Boolean)
      )(_.useDefaults)
      .optionallyWith(
        principalTags.map(value =>
          value
            .map({ case (key, value) =>
              (PrincipalTagID
                .unwrap(key): java.lang.String) -> (PrincipalTagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.principalTags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly =
    zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
      .wrap(buildAwsValue())
}
object GetPrincipalTagAttributeMapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse =
      zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse(
        identityPoolId.map(value => value),
        identityProviderName.map(value => value),
        useDefaults.map(value => value),
        principalTags.map(value => value)
      )
    def identityPoolId: Option[IdentityPoolId]
    def identityProviderName: Option[IdentityProviderName]
    def useDefaults: Option[UseDefaults]
    def principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getIdentityProviderName: ZIO[Any, AwsError, IdentityProviderName] =
      AwsError.unwrapOptionField("identityProviderName", identityProviderName)
    def getUseDefaults: ZIO[Any, AwsError, UseDefaults] =
      AwsError.unwrapOptionField("useDefaults", useDefaults)
    def getPrincipalTags
        : ZIO[Any, AwsError, Map[PrincipalTagID, PrincipalTagValue]] =
      AwsError.unwrapOptionField("principalTags", principalTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
  ) extends zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly {
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.IdentityPoolId(value)
      )
    override val identityProviderName: Option[IdentityProviderName] = scala
      .Option(impl.identityProviderName())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.IdentityProviderName(value)
      )
    override val useDefaults: Option[UseDefaults] = scala
      .Option(impl.useDefaults())
      .map(value => zio.aws.cognitoidentity.model.primitives.UseDefaults(value))
    override val principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]] =
      scala
        .Option(impl.principalTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives
                .PrincipalTagID(key) -> zio.aws.cognitoidentity.model.primitives
                .PrincipalTagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
  ): zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly =
    new Wrapper(impl)
}
