package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  CognitoIdentityProviderTokenCheck,
  CognitoIdentityProviderClientId,
  CognitoIdentityProviderName
}
import scala.jdk.CollectionConverters.*
final case class CognitoIdentityProvider(
    providerName: Option[CognitoIdentityProviderName] = None,
    clientId: Option[CognitoIdentityProviderClientId] = None,
    serverSideTokenCheck: Option[CognitoIdentityProviderTokenCheck] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider = {
    import CognitoIdentityProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider
      .builder()
      .optionallyWith(
        providerName.map(value =>
          CognitoIdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.providerName)
      .optionallyWith(
        clientId.map(value =>
          CognitoIdentityProviderClientId.unwrap(value): java.lang.String
        )
      )(_.clientId)
      .optionallyWith(
        serverSideTokenCheck.map(value =>
          CognitoIdentityProviderTokenCheck.unwrap(value): java.lang.Boolean
        )
      )(_.serverSideTokenCheck)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly =
    zio.aws.cognitoidentity.model.CognitoIdentityProvider.wrap(buildAwsValue())
}
object CognitoIdentityProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.CognitoIdentityProvider =
      zio.aws.cognitoidentity.model.CognitoIdentityProvider(
        providerName.map(value => value),
        clientId.map(value => value),
        serverSideTokenCheck.map(value => value)
      )
    def providerName: Option[CognitoIdentityProviderName]
    def clientId: Option[CognitoIdentityProviderClientId]
    def serverSideTokenCheck: Option[CognitoIdentityProviderTokenCheck]
    def getProviderName: ZIO[Any, AwsError, CognitoIdentityProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getClientId: ZIO[Any, AwsError, CognitoIdentityProviderClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getServerSideTokenCheck
        : ZIO[Any, AwsError, CognitoIdentityProviderTokenCheck] =
      AwsError.unwrapOptionField("serverSideTokenCheck", serverSideTokenCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider
  ) extends zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly {
    override val providerName: Option[CognitoIdentityProviderName] = scala
      .Option(impl.providerName())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives
          .CognitoIdentityProviderName(value)
      )
    override val clientId: Option[CognitoIdentityProviderClientId] = scala
      .Option(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives
          .CognitoIdentityProviderClientId(value)
      )
    override val serverSideTokenCheck
        : Option[CognitoIdentityProviderTokenCheck] = scala
      .Option(impl.serverSideTokenCheck())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives
          .CognitoIdentityProviderTokenCheck(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider
  ): zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly =
    new Wrapper(impl)
}
