package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  ClassicFlow,
  DeveloperProviderName,
  IdentityPoolId,
  ARNString,
  IdentityPoolUnauthenticated,
  IdentityProviderId,
  IdentityProviderName,
  TagKeysType,
  TagValueType,
  IdentityPoolName
}
import scala.jdk.CollectionConverters.*
final case class UpdateIdentityPoolResponse(
    identityPoolId: IdentityPoolId,
    identityPoolName: IdentityPoolName,
    allowUnauthenticatedIdentities: IdentityPoolUnauthenticated,
    allowClassicFlow: Option[ClassicFlow] = None,
    supportedLoginProviders: Option[
      Map[IdentityProviderName, IdentityProviderId]
    ] = None,
    developerProviderName: Option[DeveloperProviderName] = None,
    openIdConnectProviderARNs: Option[Iterable[ARNString]] = None,
    cognitoIdentityProviders: Option[
      Iterable[zio.aws.cognitoidentity.model.CognitoIdentityProvider]
    ] = None,
    samlProviderARNs: Option[Iterable[ARNString]] = None,
    identityPoolTags: Option[Map[TagKeysType, TagValueType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse = {
    import UpdateIdentityPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityPoolName(
        IdentityPoolName.unwrap(identityPoolName): java.lang.String
      )
      .allowUnauthenticatedIdentities(
        IdentityPoolUnauthenticated.unwrap(
          allowUnauthenticatedIdentities
        ): java.lang.Boolean
      )
      .optionallyWith(
        allowClassicFlow.map(value =>
          ClassicFlow.unwrap(value): java.lang.Boolean
        )
      )(_.allowClassicFlow)
      .optionallyWith(
        supportedLoginProviders.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName.unwrap(
                key
              ): java.lang.String) -> (IdentityProviderId.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.supportedLoginProviders)
      .optionallyWith(
        developerProviderName.map(value =>
          DeveloperProviderName.unwrap(value): java.lang.String
        )
      )(_.developerProviderName)
      .optionallyWith(
        openIdConnectProviderARNs.map(value =>
          value.map { item =>
            ARNString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.openIdConnectProviderARNs)
      .optionallyWith(
        cognitoIdentityProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cognitoIdentityProviders)
      .optionallyWith(
        samlProviderARNs.map(value =>
          value.map { item =>
            ARNString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.samlProviderARNs)
      .optionallyWith(
        identityPoolTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.identityPoolTags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly =
    zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse
      .wrap(buildAwsValue())
}
object UpdateIdentityPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse =
      zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse(
        identityPoolId,
        identityPoolName,
        allowUnauthenticatedIdentities,
        allowClassicFlow.map(value => value),
        supportedLoginProviders.map(value => value),
        developerProviderName.map(value => value),
        openIdConnectProviderARNs.map(value => value),
        cognitoIdentityProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        samlProviderARNs.map(value => value),
        identityPoolTags.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityPoolName: IdentityPoolName
    def allowUnauthenticatedIdentities: IdentityPoolUnauthenticated
    def allowClassicFlow: Option[ClassicFlow]
    def supportedLoginProviders
        : Option[Map[IdentityProviderName, IdentityProviderId]]
    def developerProviderName: Option[DeveloperProviderName]
    def openIdConnectProviderARNs: Option[List[ARNString]]
    def cognitoIdentityProviders: Option[
      List[zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly]
    ]
    def samlProviderARNs: Option[List[ARNString]]
    def identityPoolTags: Option[Map[TagKeysType, TagValueType]]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityPoolName: ZIO[Any, Nothing, IdentityPoolName] =
      ZIO.succeed(identityPoolName)
    def getAllowUnauthenticatedIdentities
        : ZIO[Any, Nothing, IdentityPoolUnauthenticated] =
      ZIO.succeed(allowUnauthenticatedIdentities)
    def getAllowClassicFlow: ZIO[Any, AwsError, ClassicFlow] =
      AwsError.unwrapOptionField("allowClassicFlow", allowClassicFlow)
    def getSupportedLoginProviders
        : ZIO[Any, AwsError, Map[IdentityProviderName, IdentityProviderId]] =
      AwsError.unwrapOptionField(
        "supportedLoginProviders",
        supportedLoginProviders
      )
    def getDeveloperProviderName: ZIO[Any, AwsError, DeveloperProviderName] =
      AwsError.unwrapOptionField("developerProviderName", developerProviderName)
    def getOpenIdConnectProviderARNs: ZIO[Any, AwsError, List[ARNString]] =
      AwsError.unwrapOptionField(
        "openIdConnectProviderARNs",
        openIdConnectProviderARNs
      )
    def getCognitoIdentityProviders: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cognitoIdentityProviders",
      cognitoIdentityProviders
    )
    def getSamlProviderARNs: ZIO[Any, AwsError, List[ARNString]] =
      AwsError.unwrapOptionField("samlProviderARNs", samlProviderARNs)
    def getIdentityPoolTags
        : ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("identityPoolTags", identityPoolTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse
  ) extends zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val identityPoolName: IdentityPoolName =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolName(impl.identityPoolName())
    override val allowUnauthenticatedIdentities: IdentityPoolUnauthenticated =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolUnauthenticated(impl.allowUnauthenticatedIdentities())
    override val allowClassicFlow: Option[ClassicFlow] = scala
      .Option(impl.allowClassicFlow())
      .map(value => zio.aws.cognitoidentity.model.primitives.ClassicFlow(value))
    override val supportedLoginProviders
        : Option[Map[IdentityProviderName, IdentityProviderId]] = scala
      .Option(impl.supportedLoginProviders())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
              key
            ) -> zio.aws.cognitoidentity.model.primitives
              .IdentityProviderId(value)
          })
          .toMap
      )
    override val developerProviderName: Option[DeveloperProviderName] = scala
      .Option(impl.developerProviderName())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.DeveloperProviderName(value)
      )
    override val openIdConnectProviderARNs: Option[List[ARNString]] = scala
      .Option(impl.openIdConnectProviderARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.primitives.ARNString(item)
        }.toList
      )
    override val cognitoIdentityProviders: Option[
      List[zio.aws.cognitoidentity.model.CognitoIdentityProvider.ReadOnly]
    ] = scala
      .Option(impl.cognitoIdentityProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.CognitoIdentityProvider.wrap(item)
        }.toList
      )
    override val samlProviderARNs: Option[List[ARNString]] = scala
      .Option(impl.samlProviderARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.primitives.ARNString(item)
        }.toList
      )
    override val identityPoolTags: Option[Map[TagKeysType, TagValueType]] =
      scala
        .Option(impl.identityPoolTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives.TagKeysType(
                key
              ) -> zio.aws.cognitoidentity.model.primitives.TagValueType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse
  ): zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly =
    new Wrapper(impl)
}
