package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.IdentityId
import scala.jdk.CollectionConverters.*
final case class DeleteIdentitiesRequest(
    identityIdsToDelete: Iterable[IdentityId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest = {
    import DeleteIdentitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest
      .builder()
      .identityIdsToDelete(identityIdsToDelete.map { item =>
        IdentityId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.DeleteIdentitiesRequest.ReadOnly =
    zio.aws.cognitoidentity.model.DeleteIdentitiesRequest.wrap(buildAwsValue())
}
object DeleteIdentitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.DeleteIdentitiesRequest =
      zio.aws.cognitoidentity.model.DeleteIdentitiesRequest(identityIdsToDelete)
    def identityIdsToDelete: List[IdentityId]
    def getIdentityIdsToDelete: ZIO[Any, Nothing, List[IdentityId]] =
      ZIO.succeed(identityIdsToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest
  ) extends zio.aws.cognitoidentity.model.DeleteIdentitiesRequest.ReadOnly {
    override val identityIdsToDelete: List[IdentityId] = impl
      .identityIdsToDelete()
      .asScala
      .map { item =>
        zio.aws.cognitoidentity.model.primitives.IdentityId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest
  ): zio.aws.cognitoidentity.model.DeleteIdentitiesRequest.ReadOnly =
    new Wrapper(impl)
}
