package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentity.model.primitives.{
  DateType,
  SessionTokenString,
  SecretKeyString,
  AccessKeyString
}
import scala.jdk.CollectionConverters.*
final case class Credentials(
    accessKeyId: Option[AccessKeyString] = None,
    secretKey: Option[SecretKeyString] = None,
    sessionToken: Option[SessionTokenString] = None,
    expiration: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.Credentials
      .builder()
      .optionallyWith(
        accessKeyId.map(value =>
          AccessKeyString.unwrap(value): java.lang.String
        )
      )(_.accessKeyId)
      .optionallyWith(
        secretKey.map(value => SecretKeyString.unwrap(value): java.lang.String)
      )(_.secretKey)
      .optionallyWith(
        sessionToken.map(value =>
          SessionTokenString.unwrap(value): java.lang.String
        )
      )(_.sessionToken)
      .optionallyWith(expiration.map(value => DateType.unwrap(value): Instant))(
        _.expiration
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.Credentials.ReadOnly =
    zio.aws.cognitoidentity.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.Credentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.Credentials =
      zio.aws.cognitoidentity.model.Credentials(
        accessKeyId.map(value => value),
        secretKey.map(value => value),
        sessionToken.map(value => value),
        expiration.map(value => value)
      )
    def accessKeyId: Option[AccessKeyString]
    def secretKey: Option[SecretKeyString]
    def sessionToken: Option[SessionTokenString]
    def expiration: Option[DateType]
    def getAccessKeyId: ZIO[Any, AwsError, AccessKeyString] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretKey: ZIO[Any, AwsError, SecretKeyString] =
      AwsError.unwrapOptionField("secretKey", secretKey)
    def getSessionToken: ZIO[Any, AwsError, SessionTokenString] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
    def getExpiration: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.Credentials
  ) extends zio.aws.cognitoidentity.model.Credentials.ReadOnly {
    override val accessKeyId: Option[AccessKeyString] = scala
      .Option(impl.accessKeyId())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.AccessKeyString(value)
      )
    override val secretKey: Option[SecretKeyString] = scala
      .Option(impl.secretKey())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.SecretKeyString(value)
      )
    override val sessionToken: Option[SessionTokenString] = scala
      .Option(impl.sessionToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.SessionTokenString(value)
      )
    override val expiration: Option[DateType] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.Credentials
  ): zio.aws.cognitoidentity.model.Credentials.ReadOnly = new Wrapper(impl)
}
