package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{OIDCToken, IdentityId}
import scala.jdk.CollectionConverters.*
final case class GetOpenIdTokenForDeveloperIdentityResponse(
    identityId: Option[IdentityId] = None,
    token: Option[OIDCToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse = {
    import GetOpenIdTokenForDeveloperIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        token.map(value => OIDCToken.unwrap(value): java.lang.String)
      )(_.token)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly =
    zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
      .wrap(buildAwsValue())
}
object GetOpenIdTokenForDeveloperIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse =
      zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse(
        identityId.map(value => value),
        token.map(value => value)
      )
    def identityId: Option[IdentityId]
    def token: Option[OIDCToken]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getToken: ZIO[Any, AwsError, OIDCToken] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
  ) extends zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly {
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val token: Option[OIDCToken] = scala
      .Option(impl.token())
      .map(value => zio.aws.cognitoidentity.model.primitives.OIDCToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
  ): zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
