package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  PrincipalTagID,
  PrincipalTagValue,
  UseDefaults,
  IdentityPoolId,
  IdentityProviderName
}
import scala.jdk.CollectionConverters.*
final case class SetPrincipalTagAttributeMapRequest(
    identityPoolId: IdentityPoolId,
    identityProviderName: IdentityProviderName,
    useDefaults: Option[UseDefaults] = None,
    principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest = {
    import SetPrincipalTagAttributeMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityProviderName(
        IdentityProviderName.unwrap(identityProviderName): java.lang.String
      )
      .optionallyWith(
        useDefaults.map(value => UseDefaults.unwrap(value): java.lang.Boolean)
      )(_.useDefaults)
      .optionallyWith(
        principalTags.map(value =>
          value
            .map({ case (key, value) =>
              (PrincipalTagID
                .unwrap(key): java.lang.String) -> (PrincipalTagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.principalTags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapRequest.ReadOnly =
    zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapRequest
      .wrap(buildAwsValue())
}
object SetPrincipalTagAttributeMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapRequest =
      zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapRequest(
        identityPoolId,
        identityProviderName,
        useDefaults.map(value => value),
        principalTags.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityProviderName: IdentityProviderName
    def useDefaults: Option[UseDefaults]
    def principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityProviderName: ZIO[Any, Nothing, IdentityProviderName] =
      ZIO.succeed(identityProviderName)
    def getUseDefaults: ZIO[Any, AwsError, UseDefaults] =
      AwsError.unwrapOptionField("useDefaults", useDefaults)
    def getPrincipalTags
        : ZIO[Any, AwsError, Map[PrincipalTagID, PrincipalTagValue]] =
      AwsError.unwrapOptionField("principalTags", principalTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest
  ) extends zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val identityProviderName: IdentityProviderName =
      zio.aws.cognitoidentity.model.primitives
        .IdentityProviderName(impl.identityProviderName())
    override val useDefaults: Option[UseDefaults] = scala
      .Option(impl.useDefaults())
      .map(value => zio.aws.cognitoidentity.model.primitives.UseDefaults(value))
    override val principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]] =
      scala
        .Option(impl.principalTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives
                .PrincipalTagID(key) -> zio.aws.cognitoidentity.model.primitives
                .PrincipalTagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest
  ): zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapRequest.ReadOnly =
    new Wrapper(impl)
}
