package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{
  IdentityProviderName,
  IdentityPoolId
}
import scala.jdk.CollectionConverters._
final case class GetPrincipalTagAttributeMapRequest(
    identityPoolId: IdentityPoolId,
    identityProviderName: IdentityProviderName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest = {
    import GetPrincipalTagAttributeMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityProviderName(
        IdentityProviderName.unwrap(identityProviderName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapRequest.ReadOnly =
    zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapRequest
      .wrap(buildAwsValue())
}
object GetPrincipalTagAttributeMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapRequest =
      zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapRequest(
        identityPoolId,
        identityProviderName
      )
    def identityPoolId: IdentityPoolId
    def identityProviderName: IdentityProviderName
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityProviderName: ZIO[Any, Nothing, IdentityProviderName] =
      ZIO.succeed(identityProviderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest
  ) extends zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val identityProviderName: IdentityProviderName =
      zio.aws.cognitoidentity.model.primitives
        .IdentityProviderName(impl.identityProviderName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest
  ): zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapRequest.ReadOnly =
    new Wrapper(impl)
}
