package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  IdentityProviderName,
  ARNString,
  RoleType,
  IdentityPoolId
}
import scala.jdk.CollectionConverters._
final case class SetIdentityPoolRolesRequest(
    identityPoolId: IdentityPoolId,
    roles: Map[RoleType, ARNString],
    roleMappings: Optional[
      Map[IdentityProviderName, zio.aws.cognitoidentity.model.RoleMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest = {
    import SetIdentityPoolRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .roles(
        roles
          .map({ case (key, value) =>
            (RoleType.unwrap(key): java.lang.String) -> (ARNString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        roleMappings.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.roleMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.SetIdentityPoolRolesRequest.ReadOnly =
    zio.aws.cognitoidentity.model.SetIdentityPoolRolesRequest
      .wrap(buildAwsValue())
}
object SetIdentityPoolRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.SetIdentityPoolRolesRequest =
      zio.aws.cognitoidentity.model.SetIdentityPoolRolesRequest(
        identityPoolId,
        roles,
        roleMappings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def identityPoolId: IdentityPoolId
    def roles: Map[RoleType, ARNString]
    def roleMappings: Optional[Map[
      IdentityProviderName,
      zio.aws.cognitoidentity.model.RoleMapping.ReadOnly
    ]]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getRoles: ZIO[Any, Nothing, Map[RoleType, ARNString]] =
      ZIO.succeed(roles)
    def getRoleMappings: ZIO[Any, AwsError, Map[
      IdentityProviderName,
      zio.aws.cognitoidentity.model.RoleMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("roleMappings", roleMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest
  ) extends zio.aws.cognitoidentity.model.SetIdentityPoolRolesRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val roles: Map[RoleType, ARNString] = impl
      .roles()
      .asScala
      .map({ case (key, value) =>
        zio.aws.cognitoidentity.model.primitives.RoleType(
          key
        ) -> zio.aws.cognitoidentity.model.primitives.ARNString(value)
      })
      .toMap
    override val roleMappings: Optional[Map[
      IdentityProviderName,
      zio.aws.cognitoidentity.model.RoleMapping.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.roleMappings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
              key
            ) -> zio.aws.cognitoidentity.model.RoleMapping.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest
  ): zio.aws.cognitoidentity.model.SetIdentityPoolRolesRequest.ReadOnly =
    new Wrapper(impl)
}
