package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.IdentityPoolId
import scala.jdk.CollectionConverters._
final case class GetIdentityPoolRolesRequest(identityPoolId: IdentityPoolId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest = {
    import GetIdentityPoolRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetIdentityPoolRolesRequest.ReadOnly =
    zio.aws.cognitoidentity.model.GetIdentityPoolRolesRequest
      .wrap(buildAwsValue())
}
object GetIdentityPoolRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.GetIdentityPoolRolesRequest =
      zio.aws.cognitoidentity.model.GetIdentityPoolRolesRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest
  ) extends zio.aws.cognitoidentity.model.GetIdentityPoolRolesRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest
  ): zio.aws.cognitoidentity.model.GetIdentityPoolRolesRequest.ReadOnly =
    new Wrapper(impl)
}
