package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{
  IdentityProviderToken,
  IdentityProviderName,
  IdentityPoolId,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class GetIdRequest(
    accountId: Optional[AccountId] = Optional.Absent,
    identityPoolId: IdentityPoolId,
    logins: Optional[Map[IdentityProviderName, IdentityProviderToken]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest = {
    import GetIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .optionallyWith(
        logins.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName
                .unwrap(key): java.lang.String) -> (IdentityProviderToken
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.logins)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.GetIdRequest.ReadOnly =
    zio.aws.cognitoidentity.model.GetIdRequest.wrap(buildAwsValue())
}
object GetIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.GetIdRequest =
      zio.aws.cognitoidentity.model.GetIdRequest(
        accountId.map(value => value),
        identityPoolId,
        logins.map(value => value)
      )
    def accountId: Optional[AccountId]
    def identityPoolId: IdentityPoolId
    def logins: Optional[Map[IdentityProviderName, IdentityProviderToken]]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getLogins
        : ZIO[Any, AwsError, Map[IdentityProviderName, IdentityProviderToken]] =
      AwsError.unwrapOptionField("logins", logins)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest
  ) extends zio.aws.cognitoidentity.model.GetIdRequest.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.cognitoidentity.model.primitives.AccountId(value))
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val logins
        : Optional[Map[IdentityProviderName, IdentityProviderToken]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logins())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
                key
              ) -> zio.aws.cognitoidentity.model.primitives
                .IdentityProviderToken(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest
  ): zio.aws.cognitoidentity.model.GetIdRequest.ReadOnly = new Wrapper(impl)
}
