package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{
  ARNString,
  ClaimValue,
  ClaimName
}
import scala.jdk.CollectionConverters._
final case class MappingRule(
    claim: ClaimName,
    matchType: zio.aws.cognitoidentity.model.MappingRuleMatchType,
    value: ClaimValue,
    roleARN: ARNString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.MappingRule = {
    import MappingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.MappingRule
      .builder()
      .claim(ClaimName.unwrap(claim): java.lang.String)
      .matchType(matchType.unwrap)
      .value(ClaimValue.unwrap(value): java.lang.String)
      .roleARN(ARNString.unwrap(roleARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.MappingRule.ReadOnly =
    zio.aws.cognitoidentity.model.MappingRule.wrap(buildAwsValue())
}
object MappingRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.MappingRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.MappingRule =
      zio.aws.cognitoidentity.model.MappingRule(
        claim,
        matchType,
        value,
        roleARN
      )
    def claim: ClaimName
    def matchType: zio.aws.cognitoidentity.model.MappingRuleMatchType
    def value: ClaimValue
    def roleARN: ARNString
    def getClaim: ZIO[Any, Nothing, ClaimName] = ZIO.succeed(claim)
    def getMatchType: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentity.model.MappingRuleMatchType
    ] = ZIO.succeed(matchType)
    def getValue: ZIO[Any, Nothing, ClaimValue] = ZIO.succeed(value)
    def getRoleARN: ZIO[Any, Nothing, ARNString] = ZIO.succeed(roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.MappingRule
  ) extends zio.aws.cognitoidentity.model.MappingRule.ReadOnly {
    override val claim: ClaimName =
      zio.aws.cognitoidentity.model.primitives.ClaimName(impl.claim())
    override val matchType: zio.aws.cognitoidentity.model.MappingRuleMatchType =
      zio.aws.cognitoidentity.model.MappingRuleMatchType.wrap(impl.matchType())
    override val value: ClaimValue =
      zio.aws.cognitoidentity.model.primitives.ClaimValue(impl.value())
    override val roleARN: ARNString =
      zio.aws.cognitoidentity.model.primitives.ARNString(impl.roleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.MappingRule
  ): zio.aws.cognitoidentity.model.MappingRule.ReadOnly = new Wrapper(impl)
}
