package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.{OIDCToken, IdentityId}
import scala.jdk.CollectionConverters._
final case class GetOpenIdTokenForDeveloperIdentityResponse(
    identityId: Optional[IdentityId] = Optional.Absent,
    token: Optional[OIDCToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse = {
    import GetOpenIdTokenForDeveloperIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        token.map(value => OIDCToken.unwrap(value): java.lang.String)
      )(_.token)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly =
    zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
      .wrap(buildAwsValue())
}
object GetOpenIdTokenForDeveloperIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse =
      zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse(
        identityId.map(value => value),
        token.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def token: Optional[OIDCToken]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getToken: ZIO[Any, AwsError, OIDCToken] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
  ) extends zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val token: Optional[OIDCToken] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value => zio.aws.cognitoidentity.model.primitives.OIDCToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
  ): zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
