package zio.aws.cognitoidentity.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.cognitoidentity.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentity.model.ErrorCode
  ): zio.aws.cognitoidentity.model.ErrorCode = value match {
    case software.amazon.awssdk.services.cognitoidentity.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentity.model.ErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.cognitoidentity.model.ErrorCode.INTERNAL_SERVER_ERROR =>
      val r = InternalServerError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.ErrorCode =
      software.amazon.awssdk.services.cognitoidentity.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AccessDenied extends zio.aws.cognitoidentity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.ErrorCode =
      software.amazon.awssdk.services.cognitoidentity.model.ErrorCode.ACCESS_DENIED
  }
  case object InternalServerError
      extends zio.aws.cognitoidentity.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.ErrorCode =
      software.amazon.awssdk.services.cognitoidentity.model.ErrorCode.INTERNAL_SERVER_ERROR
  }
}
