package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class ListIdentityPoolsResponse(
    identityPools: Optional[
      Iterable[zio.aws.cognitoidentity.model.IdentityPoolShortDescription]
    ] = Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse = {
    import ListIdentityPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse
      .builder()
      .optionallyWith(
        identityPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityPools)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly =
    zio.aws.cognitoidentity.model.ListIdentityPoolsResponse
      .wrap(buildAwsValue())
}
object ListIdentityPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListIdentityPoolsResponse =
      zio.aws.cognitoidentity.model.ListIdentityPoolsResponse(
        identityPools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def identityPools: Optional[
      List[zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly]
    ]
    def nextToken: Optional[PaginationKey]
    def getIdentityPools: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("identityPools", identityPools)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse
  ) extends zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly {
    override val identityPools: Optional[
      List[zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.identityPools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.IdentityPoolShortDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse
  ): zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly =
    new Wrapper(impl)
}
