package zio.aws.cognitoidentity.model
import zio.aws.cognitoidentity.model.primitives.{
  DateType,
  IdentityProviderName,
  IdentityId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class IdentityDescription(
    identityId: Optional[IdentityId] = Optional.Absent,
    logins: Optional[Iterable[IdentityProviderName]] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription = {
    import IdentityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        logins.map(value =>
          value.map { item =>
            IdentityProviderName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logins)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly =
    zio.aws.cognitoidentity.model.IdentityDescription.wrap(buildAwsValue())
}
object IdentityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.IdentityDescription =
      zio.aws.cognitoidentity.model.IdentityDescription(
        identityId.map(value => value),
        logins.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def logins: Optional[List[IdentityProviderName]]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getLogins: ZIO[Any, AwsError, List[IdentityProviderName]] =
      AwsError.unwrapOptionField("logins", logins)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
  ) extends zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val logins: Optional[List[IdentityProviderName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logins())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentity.model.primitives.IdentityProviderName(item)
          }.toList
        )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
  ): zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly = new Wrapper(
    impl
  )
}
