package zio.aws.cognitoidentity.model
import zio.aws.cognitoidentity.model.primitives.{
  DateType,
  IdentityProviderName,
  IdentityId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeIdentityResponse(
    identityId: Optional[IdentityId] = Optional.Absent,
    logins: Optional[Iterable[IdentityProviderName]] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse = {
    import DescribeIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        logins.map(value =>
          value.map { item =>
            IdentityProviderName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logins)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly =
    zio.aws.cognitoidentity.model.DescribeIdentityResponse.wrap(buildAwsValue())
}
object DescribeIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.DescribeIdentityResponse =
      zio.aws.cognitoidentity.model.DescribeIdentityResponse(
        identityId.map(value => value),
        logins.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def logins: Optional[List[IdentityProviderName]]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getLogins: ZIO[Any, AwsError, List[IdentityProviderName]] =
      AwsError.unwrapOptionField("logins", logins)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse
  ) extends zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val logins: Optional[List[IdentityProviderName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logins())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentity.model.primitives.IdentityProviderName(item)
          }.toList
        )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse
  ): zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
