package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentity.model.primitives.IdentityId
import scala.jdk.CollectionConverters._
final case class UnprocessedIdentityId(
    identityId: Optional[IdentityId] = Optional.Absent,
    errorCode: Optional[zio.aws.cognitoidentity.model.ErrorCode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId = {
    import UnprocessedIdentityId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.UnprocessedIdentityId.ReadOnly =
    zio.aws.cognitoidentity.model.UnprocessedIdentityId.wrap(buildAwsValue())
}
object UnprocessedIdentityId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.UnprocessedIdentityId =
      zio.aws.cognitoidentity.model.UnprocessedIdentityId(
        identityId.map(value => value),
        errorCode.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def errorCode: Optional[zio.aws.cognitoidentity.model.ErrorCode]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.cognitoidentity.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId
  ) extends zio.aws.cognitoidentity.model.UnprocessedIdentityId.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val errorCode: Optional[zio.aws.cognitoidentity.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.cognitoidentity.model.ErrorCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId
  ): zio.aws.cognitoidentity.model.UnprocessedIdentityId.ReadOnly = new Wrapper(
    impl
  )
}
