package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{
  IdentityProviderToken,
  IdentityProviderName,
  IdentityId
}
import scala.jdk.CollectionConverters._
final case class UnlinkIdentityRequest(
    identityId: IdentityId,
    logins: Map[IdentityProviderName, IdentityProviderToken],
    loginsToRemove: Iterable[IdentityProviderName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest = {
    import UnlinkIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest
      .builder()
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .logins(
        logins
          .map({ case (key, value) =>
            (IdentityProviderName
              .unwrap(key): java.lang.String) -> (IdentityProviderToken
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .loginsToRemove(loginsToRemove.map { item =>
        IdentityProviderName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.UnlinkIdentityRequest.ReadOnly =
    zio.aws.cognitoidentity.model.UnlinkIdentityRequest.wrap(buildAwsValue())
}
object UnlinkIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.UnlinkIdentityRequest =
      zio.aws.cognitoidentity.model
        .UnlinkIdentityRequest(identityId, logins, loginsToRemove)
    def identityId: IdentityId
    def logins: Map[IdentityProviderName, IdentityProviderToken]
    def loginsToRemove: List[IdentityProviderName]
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getLogins
        : ZIO[Any, Nothing, Map[IdentityProviderName, IdentityProviderToken]] =
      ZIO.succeed(logins)
    def getLoginsToRemove: ZIO[Any, Nothing, List[IdentityProviderName]] =
      ZIO.succeed(loginsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest
  ) extends zio.aws.cognitoidentity.model.UnlinkIdentityRequest.ReadOnly {
    override val identityId: IdentityId =
      zio.aws.cognitoidentity.model.primitives.IdentityId(impl.identityId())
    override val logins: Map[IdentityProviderName, IdentityProviderToken] = impl
      .logins()
      .asScala
      .map({ case (key, value) =>
        zio.aws.cognitoidentity.model.primitives
          .IdentityProviderName(key) -> zio.aws.cognitoidentity.model.primitives
          .IdentityProviderToken(value)
      })
      .toMap
    override val loginsToRemove: List[IdentityProviderName] = impl
      .loginsToRemove()
      .asScala
      .map { item =>
        zio.aws.cognitoidentity.model.primitives.IdentityProviderName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest
  ): zio.aws.cognitoidentity.model.UnlinkIdentityRequest.ReadOnly = new Wrapper(
    impl
  )
}
