package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{
  DeveloperUserIdentifier,
  DeveloperProviderName,
  IdentityPoolId,
  IdentityId
}
import scala.jdk.CollectionConverters._
final case class UnlinkDeveloperIdentityRequest(
    identityId: IdentityId,
    identityPoolId: IdentityPoolId,
    developerProviderName: DeveloperProviderName,
    developerUserIdentifier: DeveloperUserIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest = {
    import UnlinkDeveloperIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest
      .builder()
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .developerProviderName(
        DeveloperProviderName.unwrap(developerProviderName): java.lang.String
      )
      .developerUserIdentifier(
        DeveloperUserIdentifier.unwrap(
          developerUserIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.UnlinkDeveloperIdentityRequest.ReadOnly =
    zio.aws.cognitoidentity.model.UnlinkDeveloperIdentityRequest
      .wrap(buildAwsValue())
}
object UnlinkDeveloperIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.UnlinkDeveloperIdentityRequest =
      zio.aws.cognitoidentity.model.UnlinkDeveloperIdentityRequest(
        identityId,
        identityPoolId,
        developerProviderName,
        developerUserIdentifier
      )
    def identityId: IdentityId
    def identityPoolId: IdentityPoolId
    def developerProviderName: DeveloperProviderName
    def developerUserIdentifier: DeveloperUserIdentifier
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getDeveloperProviderName: ZIO[Any, Nothing, DeveloperProviderName] =
      ZIO.succeed(developerProviderName)
    def getDeveloperUserIdentifier: ZIO[Any, Nothing, DeveloperUserIdentifier] =
      ZIO.succeed(developerUserIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest
  ) extends zio.aws.cognitoidentity.model.UnlinkDeveloperIdentityRequest.ReadOnly {
    override val identityId: IdentityId =
      zio.aws.cognitoidentity.model.primitives.IdentityId(impl.identityId())
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val developerProviderName: DeveloperProviderName =
      zio.aws.cognitoidentity.model.primitives
        .DeveloperProviderName(impl.developerProviderName())
    override val developerUserIdentifier: DeveloperUserIdentifier =
      zio.aws.cognitoidentity.model.primitives
        .DeveloperUserIdentifier(impl.developerUserIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest
  ): zio.aws.cognitoidentity.model.UnlinkDeveloperIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
