package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.IdentityId
import scala.jdk.CollectionConverters._
final case class DescribeIdentityRequest(identityId: IdentityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest = {
    import DescribeIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest
      .builder()
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.DescribeIdentityRequest.ReadOnly =
    zio.aws.cognitoidentity.model.DescribeIdentityRequest.wrap(buildAwsValue())
}
object DescribeIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.DescribeIdentityRequest =
      zio.aws.cognitoidentity.model.DescribeIdentityRequest(identityId)
    def identityId: IdentityId
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest
  ) extends zio.aws.cognitoidentity.model.DescribeIdentityRequest.ReadOnly {
    override val identityId: IdentityId =
      zio.aws.cognitoidentity.model.primitives.IdentityId(impl.identityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest
  ): zio.aws.cognitoidentity.model.DescribeIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
