package zio.aws.cognitoidentity.model
import scala.jdk.CollectionConverters._
sealed trait RoleMappingType {
  def unwrap
      : software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType
}
object RoleMappingType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType
  ): zio.aws.cognitoidentity.model.RoleMappingType = value match {
    case software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType.TOKEN =>
      val r = Token
      r
    case software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType.RULES =>
      val r = Rules
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentity.model.RoleMappingType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType =
      software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType.UNKNOWN_TO_SDK_VERSION
  }
  case object Token extends zio.aws.cognitoidentity.model.RoleMappingType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType =
      software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType.TOKEN
  }
  case object Rules extends zio.aws.cognitoidentity.model.RoleMappingType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType =
      software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType.RULES
  }
}
