package zio.aws.cognitoidentity
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.cognitoidentity.model.primitives.{
  PrincipalTagID,
  PrincipalTagValue,
  RoleType,
  IdentityId,
  DeveloperUserIdentifier,
  ARNString,
  IdentityProviderId,
  IdentityProviderName,
  TagKeysType,
  IdentityProviderToken,
  TagValueType
}
import zio.aws.cognitoidentity.model.primitives.IdentityPoolId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARNString extends Subtype[String]
    type ARNString = zio.aws.cognitoidentity.model.primitives.ARNString.Type
    object AccessKeyString extends Subtype[String]
    type AccessKeyString =
      zio.aws.cognitoidentity.model.primitives.AccessKeyString.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.cognitoidentity.model.primitives.AccountId.Type
    object ClaimName extends Subtype[String]
    type ClaimName = zio.aws.cognitoidentity.model.primitives.ClaimName.Type
    object ClaimValue extends Subtype[String]
    type ClaimValue = zio.aws.cognitoidentity.model.primitives.ClaimValue.Type
    object ClassicFlow extends Subtype[Boolean]
    type ClassicFlow = zio.aws.cognitoidentity.model.primitives.ClassicFlow.Type
    object CognitoIdentityProviderClientId extends Subtype[String]
    type CognitoIdentityProviderClientId =
      zio.aws.cognitoidentity.model.primitives.CognitoIdentityProviderClientId.Type
    object CognitoIdentityProviderName extends Subtype[String]
    type CognitoIdentityProviderName =
      zio.aws.cognitoidentity.model.primitives.CognitoIdentityProviderName.Type
    object CognitoIdentityProviderTokenCheck extends Subtype[Boolean]
    type CognitoIdentityProviderTokenCheck =
      zio.aws.cognitoidentity.model.primitives.CognitoIdentityProviderTokenCheck.Type
    object DateType extends Subtype[Instant]
    type DateType = zio.aws.cognitoidentity.model.primitives.DateType.Type
    object DeveloperProviderName extends Subtype[String]
    type DeveloperProviderName =
      zio.aws.cognitoidentity.model.primitives.DeveloperProviderName.Type
    object DeveloperUserIdentifier extends Subtype[String]
    type DeveloperUserIdentifier =
      zio.aws.cognitoidentity.model.primitives.DeveloperUserIdentifier.Type
    object HideDisabled extends Subtype[Boolean]
    type HideDisabled =
      zio.aws.cognitoidentity.model.primitives.HideDisabled.Type
    object IdentityId extends Subtype[String]
    type IdentityId = zio.aws.cognitoidentity.model.primitives.IdentityId.Type
    object IdentityPoolId extends Subtype[String]
    type IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives.IdentityPoolId.Type
    object IdentityPoolName extends Subtype[String]
    type IdentityPoolName =
      zio.aws.cognitoidentity.model.primitives.IdentityPoolName.Type
    object IdentityPoolUnauthenticated extends Subtype[Boolean]
    type IdentityPoolUnauthenticated =
      zio.aws.cognitoidentity.model.primitives.IdentityPoolUnauthenticated.Type
    object IdentityProviderId extends Subtype[String]
    type IdentityProviderId =
      zio.aws.cognitoidentity.model.primitives.IdentityProviderId.Type
    object IdentityProviderName extends Subtype[String]
    type IdentityProviderName =
      zio.aws.cognitoidentity.model.primitives.IdentityProviderName.Type
    object IdentityProviderToken extends Subtype[String]
    type IdentityProviderToken =
      zio.aws.cognitoidentity.model.primitives.IdentityProviderToken.Type
    object OIDCToken extends Subtype[String]
    type OIDCToken = zio.aws.cognitoidentity.model.primitives.OIDCToken.Type
    object PaginationKey extends Subtype[String]
    type PaginationKey =
      zio.aws.cognitoidentity.model.primitives.PaginationKey.Type
    object PrincipalTagID extends Subtype[String]
    type PrincipalTagID =
      zio.aws.cognitoidentity.model.primitives.PrincipalTagID.Type
    object PrincipalTagValue extends Subtype[String]
    type PrincipalTagValue =
      zio.aws.cognitoidentity.model.primitives.PrincipalTagValue.Type
    object QueryLimit extends Subtype[Int]
    type QueryLimit = zio.aws.cognitoidentity.model.primitives.QueryLimit.Type
    object RoleType extends Subtype[String]
    type RoleType = zio.aws.cognitoidentity.model.primitives.RoleType.Type
    object SecretKeyString extends Subtype[String]
    type SecretKeyString =
      zio.aws.cognitoidentity.model.primitives.SecretKeyString.Type
    object SessionTokenString extends Subtype[String]
    type SessionTokenString =
      zio.aws.cognitoidentity.model.primitives.SessionTokenString.Type
    object TagKeysType extends Subtype[String]
    type TagKeysType = zio.aws.cognitoidentity.model.primitives.TagKeysType.Type
    object TagValueType extends Subtype[String]
    type TagValueType =
      zio.aws.cognitoidentity.model.primitives.TagValueType.Type
    object TokenDuration extends Subtype[Long]
    type TokenDuration =
      zio.aws.cognitoidentity.model.primitives.TokenDuration.Type
    object UseDefaults extends Subtype[Boolean]
    type UseDefaults = zio.aws.cognitoidentity.model.primitives.UseDefaults.Type
  }
  type CognitoIdentityProviderList =
    List[zio.aws.cognitoidentity.model.CognitoIdentityProvider]
  type DeveloperUserIdentifierList = List[DeveloperUserIdentifier]
  type IdentitiesList = List[zio.aws.cognitoidentity.model.IdentityDescription]
  type IdentityIdList = List[IdentityId]
  type IdentityPoolTagsListType = List[TagKeysType]
  type IdentityPoolTagsType = Map[TagKeysType, TagValueType]
  type IdentityPoolsList =
    List[zio.aws.cognitoidentity.model.IdentityPoolShortDescription]
  type IdentityProviders = Map[IdentityProviderName, IdentityProviderId]
  type LoginsList = List[IdentityProviderName]
  type LoginsMap = Map[IdentityProviderName, IdentityProviderToken]
  type MappingRulesList = List[zio.aws.cognitoidentity.model.MappingRule]
  type OIDCProviderList = List[ARNString]
  type PrincipalTags = Map[PrincipalTagID, PrincipalTagValue]
  type RoleMappingMap =
    Map[IdentityProviderName, zio.aws.cognitoidentity.model.RoleMapping]
  type RolesMap = Map[RoleType, ARNString]
  type SAMLProviderList = List[ARNString]
  type UnprocessedIdentityIdList =
    List[zio.aws.cognitoidentity.model.UnprocessedIdentityId]
}
