package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{TagValueType, TagKeysType}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Map[TagKeysType, TagValueType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.cognitoidentity.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListTagsForResourceResponse =
      zio.aws.cognitoidentity.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[TagKeysType, TagValueType]]
    def getTags: ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse
  ) extends zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[TagKeysType, TagValueType]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentity.model.primitives.TagKeysType(
              key
            ) -> zio.aws.cognitoidentity.model.primitives.TagValueType(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse
  ): zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
