package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  IdentityProviderName,
  ARNString,
  RoleType,
  IdentityPoolId
}
import scala.jdk.CollectionConverters._
final case class GetIdentityPoolRolesResponse(
    identityPoolId: Option[IdentityPoolId] = None,
    roles: Option[Map[RoleType, ARNString]] = None,
    roleMappings: Option[
      Map[IdentityProviderName, zio.aws.cognitoidentity.model.RoleMapping]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse = {
    import GetIdentityPoolRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        roles.map(value =>
          value
            .map({ case (key, value) =>
              (RoleType.unwrap(key): java.lang.String) -> (ARNString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.roles)
      .optionallyWith(
        roleMappings.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.roleMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly =
    zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse
      .wrap(buildAwsValue())
}
object GetIdentityPoolRolesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse =
      zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse(
        identityPoolId.map(value => value),
        roles.map(value => value),
        roleMappings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def identityPoolId: Option[IdentityPoolId]
    def roles: Option[Map[RoleType, ARNString]]
    def roleMappings: Option[Map[
      IdentityProviderName,
      zio.aws.cognitoidentity.model.RoleMapping.ReadOnly
    ]]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getRoles: ZIO[Any, AwsError, Map[RoleType, ARNString]] =
      AwsError.unwrapOptionField("roles", roles)
    def getRoleMappings: ZIO[Any, AwsError, Map[
      IdentityProviderName,
      zio.aws.cognitoidentity.model.RoleMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("roleMappings", roleMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse
  ) extends zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly {
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.IdentityPoolId(value)
      )
    override val roles: Option[Map[RoleType, ARNString]] = scala
      .Option(impl.roles())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentity.model.primitives.RoleType(
              key
            ) -> zio.aws.cognitoidentity.model.primitives.ARNString(value)
          })
          .toMap
      )
    override val roleMappings: Option[Map[
      IdentityProviderName,
      zio.aws.cognitoidentity.model.RoleMapping.ReadOnly
    ]] = scala
      .Option(impl.roleMappings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
              key
            ) -> zio.aws.cognitoidentity.model.RoleMapping.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse
  ): zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly =
    new Wrapper(impl)
}
