package zio.aws.cognitoidentity
import zio.aws.cognitoidentity.model.GetOpenIdTokenResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.cognitoidentity.model.primitives.DeveloperUserIdentifier
import zio.aws.cognitoidentity.model.{
  DescribeIdentityRequest,
  SetPrincipalTagAttributeMapRequest,
  GetOpenIdTokenRequest,
  UpdateIdentityPoolRequest,
  ListIdentitiesRequest,
  DeleteIdentitiesRequest,
  SetIdentityPoolRolesRequest,
  DescribeIdentityPoolRequest,
  ListTagsForResourceRequest,
  UnlinkIdentityRequest,
  GetIdentityPoolRolesRequest,
  CreateIdentityPoolRequest,
  ListIdentityPoolsRequest,
  DeleteIdentityPoolRequest,
  GetPrincipalTagAttributeMapRequest,
  UntagResourceRequest,
  GetOpenIdTokenForDeveloperIdentityRequest,
  LookupDeveloperIdentityRequest,
  MergeDeveloperIdentitiesRequest,
  UnlinkDeveloperIdentityRequest,
  GetCredentialsForIdentityRequest,
  GetIdRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object CognitoIdentityMock extends Mock[CognitoIdentity] {
  object UnlinkIdentity extends Effect[UnlinkIdentityRequest, AwsError, Unit]
  object LookupDeveloperIdentity
      extends Effect[
        LookupDeveloperIdentityRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly,
          DeveloperUserIdentifier
        ]
      ]
  object LookupDeveloperIdentityPaginated
      extends Effect[
        LookupDeveloperIdentityRequest,
        AwsError,
        zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly
      ]
  object ListIdentities
      extends Effect[ListIdentitiesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly,
        zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly
      ]]
  object ListIdentitiesPaginated
      extends Effect[
        ListIdentitiesRequest,
        AwsError,
        zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly
      ]
  object GetOpenIdTokenForDeveloperIdentity
      extends Effect[
        GetOpenIdTokenForDeveloperIdentityRequest,
        AwsError,
        zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly
      ]
  object ListIdentityPools
      extends Stream[
        ListIdentityPoolsRequest,
        AwsError,
        zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly
      ]
  object ListIdentityPoolsPaginated
      extends Effect[
        ListIdentityPoolsRequest,
        AwsError,
        zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly
      ]
  object GetId
      extends Effect[
        GetIdRequest,
        AwsError,
        zio.aws.cognitoidentity.model.GetIdResponse.ReadOnly
      ]
  object GetIdentityPoolRoles
      extends Effect[
        GetIdentityPoolRolesRequest,
        AwsError,
        zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly
      ]
  object DescribeIdentityPool
      extends Effect[
        DescribeIdentityPoolRequest,
        AwsError,
        zio.aws.cognitoidentity.model.DescribeIdentityPoolResponse.ReadOnly
      ]
  object GetCredentialsForIdentity
      extends Effect[
        GetCredentialsForIdentityRequest,
        AwsError,
        zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly
      ]
  object DescribeIdentity
      extends Effect[
        DescribeIdentityRequest,
        AwsError,
        zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly
      ]
  object DeleteIdentities
      extends Effect[
        DeleteIdentitiesRequest,
        AwsError,
        zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.cognitoidentity.model.UntagResourceResponse.ReadOnly
      ]
  object MergeDeveloperIdentities
      extends Effect[
        MergeDeveloperIdentitiesRequest,
        AwsError,
        zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly
      ]
  object DeleteIdentityPool
      extends Effect[DeleteIdentityPoolRequest, AwsError, Unit]
  object UnlinkDeveloperIdentity
      extends Effect[UnlinkDeveloperIdentityRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateIdentityPool
      extends Effect[
        CreateIdentityPoolRequest,
        AwsError,
        zio.aws.cognitoidentity.model.CreateIdentityPoolResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.cognitoidentity.model.TagResourceResponse.ReadOnly
      ]
  object UpdateIdentityPool
      extends Effect[
        UpdateIdentityPoolRequest,
        AwsError,
        zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly
      ]
  object SetIdentityPoolRoles
      extends Effect[SetIdentityPoolRolesRequest, AwsError, Unit]
  object SetPrincipalTagAttributeMap
      extends Effect[
        SetPrincipalTagAttributeMapRequest,
        AwsError,
        zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly
      ]
  object GetOpenIdToken
      extends Effect[GetOpenIdTokenRequest, AwsError, ReadOnly]
  object GetPrincipalTagAttributeMap
      extends Effect[
        GetPrincipalTagAttributeMapRequest,
        AwsError,
        zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CognitoIdentity] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CognitoIdentity {
          val api: CognitoIdentityAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CognitoIdentity = this
          def unlinkIdentity(
              request: UnlinkIdentityRequest
          ): IO[AwsError, Unit] = proxy(UnlinkIdentity, request)
          def lookupDeveloperIdentity(
              request: LookupDeveloperIdentityRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly,
            DeveloperUserIdentifier
          ]] = proxy(LookupDeveloperIdentity, request)
          def lookupDeveloperIdentityPaginated(
              request: LookupDeveloperIdentityRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly
          ] = proxy(LookupDeveloperIdentityPaginated, request)
          def listIdentities(
              request: ListIdentitiesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly,
            zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly
          ]] = proxy(ListIdentities, request)
          def listIdentitiesPaginated(request: ListIdentitiesRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly
          ] = proxy(ListIdentitiesPaginated, request)
          def getOpenIdTokenForDeveloperIdentity(
              request: GetOpenIdTokenForDeveloperIdentityRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly
          ] = proxy(GetOpenIdTokenForDeveloperIdentity, request)
          def listIdentityPools(request: ListIdentityPoolsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly
          ] = rts.unsafeRun(proxy(ListIdentityPools, request))
          def listIdentityPoolsPaginated(request: ListIdentityPoolsRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly
          ] = proxy(ListIdentityPoolsPaginated, request)
          def getId(request: GetIdRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.GetIdResponse.ReadOnly
          ] = proxy(GetId, request)
          def getIdentityPoolRoles(request: GetIdentityPoolRolesRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly
          ] = proxy(GetIdentityPoolRoles, request)
          def describeIdentityPool(request: DescribeIdentityPoolRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.DescribeIdentityPoolResponse.ReadOnly
          ] = proxy(DescribeIdentityPool, request)
          def getCredentialsForIdentity(
              request: GetCredentialsForIdentityRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly
          ] = proxy(GetCredentialsForIdentity, request)
          def describeIdentity(request: DescribeIdentityRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly
          ] = proxy(DescribeIdentity, request)
          def deleteIdentities(request: DeleteIdentitiesRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly
          ] = proxy(DeleteIdentities, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def mergeDeveloperIdentities(
              request: MergeDeveloperIdentitiesRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly
          ] = proxy(MergeDeveloperIdentities, request)
          def deleteIdentityPool(
              request: DeleteIdentityPoolRequest
          ): IO[AwsError, Unit] = proxy(DeleteIdentityPool, request)
          def unlinkDeveloperIdentity(
              request: UnlinkDeveloperIdentityRequest
          ): IO[AwsError, Unit] = proxy(UnlinkDeveloperIdentity, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def createIdentityPool(request: CreateIdentityPoolRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.CreateIdentityPoolResponse.ReadOnly
          ] = proxy(CreateIdentityPool, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def updateIdentityPool(request: UpdateIdentityPoolRequest): IO[
            AwsError,
            zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly
          ] = proxy(UpdateIdentityPool, request)
          def setIdentityPoolRoles(
              request: SetIdentityPoolRolesRequest
          ): IO[AwsError, Unit] = proxy(SetIdentityPoolRoles, request)
          def setPrincipalTagAttributeMap(
              request: SetPrincipalTagAttributeMapRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly
          ] = proxy(SetPrincipalTagAttributeMap, request)
          def getOpenIdToken(
              request: GetOpenIdTokenRequest
          ): IO[AwsError, ReadOnly] = proxy(GetOpenIdToken, request)
          def getPrincipalTagAttributeMap(
              request: GetPrincipalTagAttributeMapRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly
          ] = proxy(GetPrincipalTagAttributeMap, request)
        }
      }
    }
    .toLayer
}
