package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  PrincipalTagID,
  PrincipalTagValue,
  IdentityId,
  IdentityPoolId,
  IdentityProviderName,
  TokenDuration,
  IdentityProviderToken
}
import scala.jdk.CollectionConverters._
final case class GetOpenIdTokenForDeveloperIdentityRequest(
    identityPoolId: IdentityPoolId,
    identityId: Option[IdentityId] = None,
    logins: Map[IdentityProviderName, IdentityProviderToken],
    principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]] = None,
    tokenDuration: Option[TokenDuration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest = {
    import GetOpenIdTokenForDeveloperIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .logins(
        logins
          .map({ case (key, value) =>
            (IdentityProviderName.unwrap(
              key
            ): java.lang.String) -> (IdentityProviderToken.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        principalTags.map(value =>
          value
            .map({ case (key, value) =>
              (PrincipalTagID
                .unwrap(key): java.lang.String) -> (PrincipalTagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.principalTags)
      .optionallyWith(
        tokenDuration.map(value => TokenDuration.unwrap(value): java.lang.Long)
      )(_.tokenDuration)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest.ReadOnly =
    zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest
      .wrap(buildAwsValue())
}
object GetOpenIdTokenForDeveloperIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest =
      zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest(
        identityPoolId,
        identityId.map(value => value),
        logins,
        principalTags.map(value => value),
        tokenDuration.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityId: Option[IdentityId]
    def logins: Map[IdentityProviderName, IdentityProviderToken]
    def principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]]
    def tokenDuration: Option[TokenDuration]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getLogins
        : ZIO[Any, Nothing, Map[IdentityProviderName, IdentityProviderToken]] =
      ZIO.succeed(logins)
    def getPrincipalTags
        : ZIO[Any, AwsError, Map[PrincipalTagID, PrincipalTagValue]] =
      AwsError.unwrapOptionField("principalTags", principalTags)
    def getTokenDuration: ZIO[Any, AwsError, TokenDuration] =
      AwsError.unwrapOptionField("tokenDuration", tokenDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest
  ) extends zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val logins: Map[IdentityProviderName, IdentityProviderToken] = impl
      .logins()
      .asScala
      .map({ case (key, value) =>
        zio.aws.cognitoidentity.model.primitives
          .IdentityProviderName(key) -> zio.aws.cognitoidentity.model.primitives
          .IdentityProviderToken(value)
      })
      .toMap
    override val principalTags: Option[Map[PrincipalTagID, PrincipalTagValue]] =
      scala
        .Option(impl.principalTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentity.model.primitives
                .PrincipalTagID(key) -> zio.aws.cognitoidentity.model.primitives
                .PrincipalTagValue(value)
            })
            .toMap
        )
    override val tokenDuration: Option[TokenDuration] = scala
      .Option(impl.tokenDuration())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.TokenDuration(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest
  ): zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
