package zio.aws.cognitoidentity.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  HideDisabled,
  PaginationKey,
  QueryLimit,
  IdentityPoolId
}
import scala.jdk.CollectionConverters._
final case class ListIdentitiesRequest(
    identityPoolId: IdentityPoolId,
    maxResults: QueryLimit,
    nextToken: Option[PaginationKey] = None,
    hideDisabled: Option[HideDisabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest = {
    import ListIdentitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .maxResults(QueryLimit.unwrap(maxResults): Integer)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        hideDisabled.map(value => HideDisabled.unwrap(value): java.lang.Boolean)
      )(_.hideDisabled)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.ListIdentitiesRequest.ReadOnly =
    zio.aws.cognitoidentity.model.ListIdentitiesRequest.wrap(buildAwsValue())
}
object ListIdentitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListIdentitiesRequest =
      zio.aws.cognitoidentity.model.ListIdentitiesRequest(
        identityPoolId,
        maxResults,
        nextToken.map(value => value),
        hideDisabled.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def maxResults: QueryLimit
    def nextToken: Option[PaginationKey]
    def hideDisabled: Option[HideDisabled]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getMaxResults: ZIO[Any, Nothing, QueryLimit] = ZIO.succeed(maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getHideDisabled: ZIO[Any, AwsError, HideDisabled] =
      AwsError.unwrapOptionField("hideDisabled", hideDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest
  ) extends zio.aws.cognitoidentity.model.ListIdentitiesRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitoidentity.model.primitives
        .IdentityPoolId(impl.identityPoolId())
    override val maxResults: QueryLimit =
      zio.aws.cognitoidentity.model.primitives.QueryLimit(impl.maxResults())
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
    override val hideDisabled: Option[HideDisabled] = scala
      .Option(impl.hideDisabled())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.HideDisabled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest
  ): zio.aws.cognitoidentity.model.ListIdentitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
