package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  PaginationKey,
  DeveloperUserIdentifier,
  IdentityId
}
import scala.jdk.CollectionConverters._
final case class LookupDeveloperIdentityResponse(
    identityId: Option[IdentityId] = None,
    developerUserIdentifierList: Option[Iterable[DeveloperUserIdentifier]] =
      None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse = {
    import LookupDeveloperIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        developerUserIdentifierList.map(value =>
          value.map { item =>
            DeveloperUserIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.developerUserIdentifierList)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly =
    zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse
      .wrap(buildAwsValue())
}
object LookupDeveloperIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse =
      zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse(
        identityId.map(value => value),
        developerUserIdentifierList.map(value => value),
        nextToken.map(value => value)
      )
    def identityId: Option[IdentityId]
    def developerUserIdentifierList: Option[List[DeveloperUserIdentifier]]
    def nextToken: Option[PaginationKey]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getDeveloperUserIdentifierList
        : ZIO[Any, AwsError, List[DeveloperUserIdentifier]] =
      AwsError.unwrapOptionField(
        "developerUserIdentifierList",
        developerUserIdentifierList
      )
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
  ) extends zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly {
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val developerUserIdentifierList
        : Option[List[DeveloperUserIdentifier]] = scala
      .Option(impl.developerUserIdentifierList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.primitives.DeveloperUserIdentifier(item)
        }.toList
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse
  ): zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
