package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteIdentitiesResponse(
    unprocessedIdentityIds: Option[
      Iterable[zio.aws.cognitoidentity.model.UnprocessedIdentityId]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse = {
    import DeleteIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse
      .builder()
      .optionallyWith(
        unprocessedIdentityIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedIdentityIds)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly =
    zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.wrap(buildAwsValue())
}
object DeleteIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.DeleteIdentitiesResponse =
      zio.aws.cognitoidentity.model.DeleteIdentitiesResponse(
        unprocessedIdentityIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedIdentityIds: Option[
      List[zio.aws.cognitoidentity.model.UnprocessedIdentityId.ReadOnly]
    ]
    def getUnprocessedIdentityIds: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentity.model.UnprocessedIdentityId.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedIdentityIds",
      unprocessedIdentityIds
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse
  ) extends zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly {
    override val unprocessedIdentityIds: Option[
      List[zio.aws.cognitoidentity.model.UnprocessedIdentityId.ReadOnly]
    ] = scala
      .Option(impl.unprocessedIdentityIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.UnprocessedIdentityId.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse
  ): zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly =
    new Wrapper(impl)
}
