package zio.aws.cognitoidentity
import zio.aws.cognitoidentity.model.GetOpenIdTokenResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.cognitoidentity.model.primitives.DeveloperUserIdentifier
import zio.aws.cognitoidentity.model.{
  DescribeIdentityRequest,
  SetPrincipalTagAttributeMapRequest,
  GetOpenIdTokenRequest,
  UpdateIdentityPoolRequest,
  ListIdentitiesRequest,
  DeleteIdentitiesRequest,
  SetIdentityPoolRolesRequest,
  DescribeIdentityPoolRequest,
  ListTagsForResourceRequest,
  UnlinkIdentityRequest,
  GetIdentityPoolRolesRequest,
  CreateIdentityPoolRequest,
  ListIdentityPoolsRequest,
  DeleteIdentityPoolRequest,
  GetPrincipalTagAttributeMapRequest,
  UntagResourceRequest,
  GetOpenIdTokenForDeveloperIdentityRequest,
  LookupDeveloperIdentityRequest,
  MergeDeveloperIdentitiesRequest,
  UnlinkDeveloperIdentityRequest,
  GetCredentialsForIdentityRequest,
  GetIdRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.cognitoidentity.{
  CognitoIdentityAsyncClientBuilder,
  CognitoIdentityAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.cognitoidentity.model.{
  DeleteIdentityPoolResponse,
  DeleteIdentitiesResponse,
  GetCredentialsForIdentityResponse,
  ListIdentityPoolsResponse,
  UnlinkIdentityResponse,
  DescribeIdentityResponse,
  GetIdentityPoolRolesResponse,
  GetOpenIdTokenResponse,
  ListIdentitiesResponse,
  CreateIdentityPoolResponse,
  LookupDeveloperIdentityResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeIdentityPoolResponse,
  GetOpenIdTokenForDeveloperIdentityResponse,
  MergeDeveloperIdentitiesResponse,
  IdentityDescription,
  GetIdResponse,
  IdentityPoolShortDescription,
  GetPrincipalTagAttributeMapResponse,
  TagResourceResponse,
  UnlinkDeveloperIdentityResponse,
  UpdateIdentityPoolResponse,
  SetPrincipalTagAttributeMapResponse,
  SetIdentityPoolRolesResponse
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait CognitoIdentity extends AspectSupport[CognitoIdentity] {
  val api: CognitoIdentityAsyncClient
  def unlinkIdentity(request: UnlinkIdentityRequest): IO[AwsError, Unit]
  def lookupDeveloperIdentity(
      request: LookupDeveloperIdentityRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly,
    DeveloperUserIdentifier
  ]]
  def lookupDeveloperIdentityPaginated(
      request: LookupDeveloperIdentityRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly
  ]
  def listIdentities(
      request: ListIdentitiesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly,
    zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly
  ]]
  def listIdentitiesPaginated(
      request: ListIdentitiesRequest
  ): IO[AwsError, zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly]
  def getOpenIdTokenForDeveloperIdentity(
      request: GetOpenIdTokenForDeveloperIdentityRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly
  ]
  def listIdentityPools(request: ListIdentityPoolsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly
  ]
  def listIdentityPoolsPaginated(request: ListIdentityPoolsRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly
  ]
  def getId(
      request: GetIdRequest
  ): IO[AwsError, zio.aws.cognitoidentity.model.GetIdResponse.ReadOnly]
  def getIdentityPoolRoles(request: GetIdentityPoolRolesRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly
  ]
  def describeIdentityPool(request: DescribeIdentityPoolRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.DescribeIdentityPoolResponse.ReadOnly
  ]
  def getCredentialsForIdentity(request: GetCredentialsForIdentityRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly
  ]
  def describeIdentity(request: DescribeIdentityRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly
  ]
  def deleteIdentities(request: DeleteIdentitiesRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.cognitoidentity.model.UntagResourceResponse.ReadOnly]
  def mergeDeveloperIdentities(request: MergeDeveloperIdentitiesRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly
  ]
  def deleteIdentityPool(request: DeleteIdentityPoolRequest): IO[AwsError, Unit]
  def unlinkDeveloperIdentity(
      request: UnlinkDeveloperIdentityRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly
  ]
  def createIdentityPool(request: CreateIdentityPoolRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.CreateIdentityPoolResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.cognitoidentity.model.TagResourceResponse.ReadOnly]
  def updateIdentityPool(request: UpdateIdentityPoolRequest): IO[
    AwsError,
    zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly
  ]
  def setIdentityPoolRoles(
      request: SetIdentityPoolRolesRequest
  ): IO[AwsError, Unit]
  def setPrincipalTagAttributeMap(
      request: SetPrincipalTagAttributeMapRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly
  ]
  def getOpenIdToken(request: GetOpenIdTokenRequest): IO[AwsError, ReadOnly]
  def getPrincipalTagAttributeMap(
      request: GetPrincipalTagAttributeMapRequest
  ): IO[
    AwsError,
    zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly
  ]
}
object CognitoIdentity {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CognitoIdentity] =
    customized(identity)
  def customized(
      customization: CognitoIdentityAsyncClientBuilder => CognitoIdentityAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CognitoIdentity] = managed(
    customization
  ).toLayer
  def managed(
      customization: CognitoIdentityAsyncClientBuilder => CognitoIdentityAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CognitoIdentity] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CognitoIdentityAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CognitoIdentityAsyncClient, CognitoIdentityAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CognitoIdentityAsyncClient,
        CognitoIdentityAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CognitoIdentityImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CognitoIdentityImpl[R](
      override val api: CognitoIdentityAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CognitoIdentity
      with AwsServiceBase[R] {
    override val serviceName: String = "CognitoIdentity"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CognitoIdentityImpl[R1] = new CognitoIdentityImpl(api, newAspect, r)
    def unlinkIdentity(request: UnlinkIdentityRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest,
        UnlinkIdentityResponse
      ]("unlinkIdentity", api.unlinkIdentity)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def lookupDeveloperIdentity(
        request: LookupDeveloperIdentityRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly,
      DeveloperUserIdentifier
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest,
      LookupDeveloperIdentityResponse,
      java.lang.String
    ](
      "lookupDeveloperIdentity",
      api.lookupDeveloperIdentity,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.developerUserIdentifierList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.cognitoidentity.model.primitives
                .DeveloperUserIdentifier(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def lookupDeveloperIdentityPaginated(
        request: LookupDeveloperIdentityRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest,
      LookupDeveloperIdentityResponse
    ]("lookupDeveloperIdentity", api.lookupDeveloperIdentity)(
      request.buildAwsValue()
    ).map(zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.wrap)
      .provideEnvironment(r)
    def listIdentities(
        request: ListIdentitiesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly,
      zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest,
      ListIdentitiesResponse,
      IdentityDescription
    ](
      "listIdentities",
      api.listIdentities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.identities().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.cognitoidentity.model.ListIdentitiesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.cognitoidentity.model.IdentityDescription.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listIdentitiesPaginated(request: ListIdentitiesRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest,
      ListIdentitiesResponse
    ]("listIdentities", api.listIdentities)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.ListIdentitiesResponse.wrap)
      .provideEnvironment(r)
    def getOpenIdTokenForDeveloperIdentity(
        request: GetOpenIdTokenForDeveloperIdentityRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest,
      GetOpenIdTokenForDeveloperIdentityResponse
    ](
      "getOpenIdTokenForDeveloperIdentity",
      api.getOpenIdTokenForDeveloperIdentity
    )(request.buildAwsValue())
      .map(
        zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.wrap
      )
      .provideEnvironment(r)
    def listIdentityPools(request: ListIdentityPoolsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest,
      ListIdentityPoolsResponse,
      IdentityPoolShortDescription
    ](
      "listIdentityPools",
      api.listIdentityPools,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.identityPools().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cognitoidentity.model.IdentityPoolShortDescription.wrap(item)
      )
      .provideEnvironment(r)
    def listIdentityPoolsPaginated(request: ListIdentityPoolsRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest,
      ListIdentityPoolsResponse
    ]("listIdentityPools", api.listIdentityPools)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.wrap)
      .provideEnvironment(r)
    def getId(
        request: GetIdRequest
    ): IO[AwsError, zio.aws.cognitoidentity.model.GetIdResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest,
        GetIdResponse
      ]("getId", api.getId)(request.buildAwsValue())
        .map(zio.aws.cognitoidentity.model.GetIdResponse.wrap)
        .provideEnvironment(r)
    def getIdentityPoolRoles(request: GetIdentityPoolRolesRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest,
      GetIdentityPoolRolesResponse
    ]("getIdentityPoolRoles", api.getIdentityPoolRoles)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.wrap)
      .provideEnvironment(r)
    def describeIdentityPool(request: DescribeIdentityPoolRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.DescribeIdentityPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest,
      DescribeIdentityPoolResponse
    ]("describeIdentityPool", api.describeIdentityPool)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.DescribeIdentityPoolResponse.wrap)
      .provideEnvironment(r)
    def getCredentialsForIdentity(
        request: GetCredentialsForIdentityRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest,
      GetCredentialsForIdentityResponse
    ]("getCredentialsForIdentity", api.getCredentialsForIdentity)(
      request.buildAwsValue()
    ).map(zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.wrap)
      .provideEnvironment(r)
    def describeIdentity(request: DescribeIdentityRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest,
      DescribeIdentityResponse
    ]("describeIdentity", api.describeIdentity)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.DescribeIdentityResponse.wrap)
      .provideEnvironment(r)
    def deleteIdentities(request: DeleteIdentitiesRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest,
      DeleteIdentitiesResponse
    ]("deleteIdentities", api.deleteIdentities)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def mergeDeveloperIdentities(request: MergeDeveloperIdentitiesRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest,
      MergeDeveloperIdentitiesResponse
    ]("mergeDeveloperIdentities", api.mergeDeveloperIdentities)(
      request.buildAwsValue()
    ).map(zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.wrap)
      .provideEnvironment(r)
    def deleteIdentityPool(
        request: DeleteIdentityPoolRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest,
      DeleteIdentityPoolResponse
    ]("deleteIdentityPool", api.deleteIdentityPool)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def unlinkDeveloperIdentity(
        request: UnlinkDeveloperIdentityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest,
      UnlinkDeveloperIdentityResponse
    ]("unlinkDeveloperIdentity", api.unlinkDeveloperIdentity)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createIdentityPool(request: CreateIdentityPoolRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.CreateIdentityPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest,
      CreateIdentityPoolResponse
    ]("createIdentityPool", api.createIdentityPool)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.CreateIdentityPoolResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateIdentityPool(request: UpdateIdentityPoolRequest): IO[
      AwsError,
      zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolRequest,
      UpdateIdentityPoolResponse
    ]("updateIdentityPool", api.updateIdentityPool)(request.buildAwsValue())
      .map(zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.wrap)
      .provideEnvironment(r)
    def setIdentityPoolRoles(
        request: SetIdentityPoolRolesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest,
      SetIdentityPoolRolesResponse
    ]("setIdentityPoolRoles", api.setIdentityPoolRoles)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def setPrincipalTagAttributeMap(
        request: SetPrincipalTagAttributeMapRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest,
      SetPrincipalTagAttributeMapResponse
    ]("setPrincipalTagAttributeMap", api.setPrincipalTagAttributeMap)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.wrap
    ).provideEnvironment(r)
    def getOpenIdToken(request: GetOpenIdTokenRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest,
        GetOpenIdTokenResponse
      ]("getOpenIdToken", api.getOpenIdToken)(request.buildAwsValue())
        .map(zio.aws.cognitoidentity.model.GetOpenIdTokenResponse.wrap)
        .provideEnvironment(r)
    def getPrincipalTagAttributeMap(
        request: GetPrincipalTagAttributeMapRequest
    ): IO[
      AwsError,
      zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest,
      GetPrincipalTagAttributeMapResponse
    ]("getPrincipalTagAttributeMap", api.getPrincipalTagAttributeMap)(
      request.buildAwsValue()
    ).map(
      zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.wrap
    ).provideEnvironment(r)
  }
  def unlinkIdentity(
      request: UnlinkIdentityRequest
  ): ZIO[zio.aws.cognitoidentity.CognitoIdentity, AwsError, Unit] =
    ZIO.serviceWithZIO(_.unlinkIdentity(request))
  def lookupDeveloperIdentity(request: LookupDeveloperIdentityRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly,
      DeveloperUserIdentifier
    ]
  ] = ZIO.serviceWithZIO(_.lookupDeveloperIdentity(request))
  def lookupDeveloperIdentityPaginated(
      request: LookupDeveloperIdentityRequest
  ): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.LookupDeveloperIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.lookupDeveloperIdentityPaginated(request))
  def listIdentities(request: ListIdentitiesRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly,
      zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listIdentities(request))
  def listIdentitiesPaginated(request: ListIdentitiesRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentitiesPaginated(request))
  def getOpenIdTokenForDeveloperIdentity(
      request: GetOpenIdTokenForDeveloperIdentityRequest
  ): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOpenIdTokenForDeveloperIdentity(request))
  def listIdentityPools(request: ListIdentityPoolsRequest): ZStream[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.IdentityPoolShortDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listIdentityPools(request))
  def listIdentityPoolsPaginated(request: ListIdentityPoolsRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.ListIdentityPoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityPoolsPaginated(request))
  def getId(request: GetIdRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.GetIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getId(request))
  def getIdentityPoolRoles(request: GetIdentityPoolRolesRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.GetIdentityPoolRolesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityPoolRoles(request))
  def describeIdentityPool(request: DescribeIdentityPoolRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.DescribeIdentityPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentityPool(request))
  def getCredentialsForIdentity(request: GetCredentialsForIdentityRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.GetCredentialsForIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCredentialsForIdentity(request))
  def describeIdentity(request: DescribeIdentityRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.DescribeIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentity(request))
  def deleteIdentities(request: DeleteIdentitiesRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.DeleteIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIdentities(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def mergeDeveloperIdentities(request: MergeDeveloperIdentitiesRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergeDeveloperIdentities(request))
  def deleteIdentityPool(
      request: DeleteIdentityPoolRequest
  ): ZIO[zio.aws.cognitoidentity.CognitoIdentity, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIdentityPool(request))
  def unlinkDeveloperIdentity(
      request: UnlinkDeveloperIdentityRequest
  ): ZIO[zio.aws.cognitoidentity.CognitoIdentity, AwsError, Unit] =
    ZIO.serviceWithZIO(_.unlinkDeveloperIdentity(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def createIdentityPool(request: CreateIdentityPoolRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.CreateIdentityPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIdentityPool(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateIdentityPool(request: UpdateIdentityPoolRequest): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.UpdateIdentityPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIdentityPool(request))
  def setIdentityPoolRoles(
      request: SetIdentityPoolRolesRequest
  ): ZIO[zio.aws.cognitoidentity.CognitoIdentity, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setIdentityPoolRoles(request))
  def setPrincipalTagAttributeMap(
      request: SetPrincipalTagAttributeMapRequest
  ): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.SetPrincipalTagAttributeMapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setPrincipalTagAttributeMap(request))
  def getOpenIdToken(
      request: GetOpenIdTokenRequest
  ): ZIO[zio.aws.cognitoidentity.CognitoIdentity, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getOpenIdToken(request))
  def getPrincipalTagAttributeMap(
      request: GetPrincipalTagAttributeMapRequest
  ): ZIO[
    zio.aws.cognitoidentity.CognitoIdentity,
    AwsError,
    zio.aws.cognitoidentity.model.GetPrincipalTagAttributeMapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPrincipalTagAttributeMap(request))
}
