package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{TagKeysType, ARNString}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ARNString,
    tagKeys: Iterable[TagKeysType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest
      .builder()
      .resourceArn(ARNString.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeysType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.UntagResourceRequest.ReadOnly =
    zio.aws.cognitoidentity.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.UntagResourceRequest =
      zio.aws.cognitoidentity.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ARNString
    def tagKeys: List[TagKeysType]
    def getResourceArn: ZIO[Any, Nothing, ARNString] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeysType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest
  ) extends zio.aws.cognitoidentity.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ARNString =
      zio.aws.cognitoidentity.model.primitives.ARNString(impl.resourceArn())
    override val tagKeys: List[TagKeysType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.cognitoidentity.model.primitives.TagKeysType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest
  ): zio.aws.cognitoidentity.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
