package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.IdentityId
import scala.jdk.CollectionConverters._
final case class MergeDeveloperIdentitiesResponse(
    identityId: Option[IdentityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse = {
    import MergeDeveloperIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly =
    zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse
      .wrap(buildAwsValue())
}
object MergeDeveloperIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse =
      zio.aws.cognitoidentity.model
        .MergeDeveloperIdentitiesResponse(identityId.map(value => value))
    def identityId: Option[IdentityId]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse
  ) extends zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly {
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse
  ): zio.aws.cognitoidentity.model.MergeDeveloperIdentitiesResponse.ReadOnly =
    new Wrapper(impl)
}
