package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{
  ARNString,
  IdentityProviderToken,
  IdentityProviderName,
  IdentityId
}
import scala.jdk.CollectionConverters._
final case class GetCredentialsForIdentityRequest(
    identityId: IdentityId,
    logins: Option[Map[IdentityProviderName, IdentityProviderToken]] = None,
    customRoleArn: Option[ARNString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest = {
    import GetCredentialsForIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest
      .builder()
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .optionallyWith(
        logins.map(value =>
          value
            .map({ case (key, value) =>
              (IdentityProviderName
                .unwrap(key): java.lang.String) -> (IdentityProviderToken
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.logins)
      .optionallyWith(
        customRoleArn.map(value => ARNString.unwrap(value): java.lang.String)
      )(_.customRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.GetCredentialsForIdentityRequest.ReadOnly =
    zio.aws.cognitoidentity.model.GetCredentialsForIdentityRequest
      .wrap(buildAwsValue())
}
object GetCredentialsForIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentity.model.GetCredentialsForIdentityRequest =
      zio.aws.cognitoidentity.model.GetCredentialsForIdentityRequest(
        identityId,
        logins.map(value => value),
        customRoleArn.map(value => value)
      )
    def identityId: IdentityId
    def logins: Option[Map[IdentityProviderName, IdentityProviderToken]]
    def customRoleArn: Option[ARNString]
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getLogins
        : ZIO[Any, AwsError, Map[IdentityProviderName, IdentityProviderToken]] =
      AwsError.unwrapOptionField("logins", logins)
    def getCustomRoleArn: ZIO[Any, AwsError, ARNString] =
      AwsError.unwrapOptionField("customRoleArn", customRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest
  ) extends zio.aws.cognitoidentity.model.GetCredentialsForIdentityRequest.ReadOnly {
    override val identityId: IdentityId =
      zio.aws.cognitoidentity.model.primitives.IdentityId(impl.identityId())
    override val logins
        : Option[Map[IdentityProviderName, IdentityProviderToken]] = scala
      .Option(impl.logins())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentity.model.primitives.IdentityProviderName(
              key
            ) -> zio.aws.cognitoidentity.model.primitives
              .IdentityProviderToken(value)
          })
          .toMap
      )
    override val customRoleArn: Option[ARNString] = scala
      .Option(impl.customRoleArn())
      .map(value => zio.aws.cognitoidentity.model.primitives.ARNString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest
  ): zio.aws.cognitoidentity.model.GetCredentialsForIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
