package zio.aws.cognitoidentity.model
import scala.jdk.CollectionConverters._
sealed trait MappingRuleMatchType {
  def unwrap: software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType
}
object MappingRuleMatchType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType
  ): zio.aws.cognitoidentity.model.MappingRuleMatchType = value match {
    case software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.EQUALS =>
      val r = Equals
      r
    case software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.CONTAINS =>
      val r = Contains
      r
    case software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.STARTS_WITH =>
      val r = StartsWith
      r
    case software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.NOT_EQUAL =>
      val r = NotEqual
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentity.model.MappingRuleMatchType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType =
      software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.UNKNOWN_TO_SDK_VERSION
  }
  case object Equals
      extends zio.aws.cognitoidentity.model.MappingRuleMatchType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType =
      software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.EQUALS
  }
  case object Contains
      extends zio.aws.cognitoidentity.model.MappingRuleMatchType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType =
      software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.CONTAINS
  }
  case object StartsWith
      extends zio.aws.cognitoidentity.model.MappingRuleMatchType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType =
      software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.STARTS_WITH
  }
  case object NotEqual
      extends zio.aws.cognitoidentity.model.MappingRuleMatchType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType =
      software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType.NOT_EQUAL
  }
}
