package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentity.model.primitives.{PaginationKey, IdentityPoolId}
import scala.jdk.CollectionConverters._
final case class ListIdentitiesResponse(
    identityPoolId: Option[IdentityPoolId] = None,
    identities: Option[
      Iterable[zio.aws.cognitoidentity.model.IdentityDescription]
    ] = None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse = {
    import ListIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        identities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identities)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly =
    zio.aws.cognitoidentity.model.ListIdentitiesResponse.wrap(buildAwsValue())
}
object ListIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.ListIdentitiesResponse =
      zio.aws.cognitoidentity.model.ListIdentitiesResponse(
        identityPoolId.map(value => value),
        identities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def identityPoolId: Option[IdentityPoolId]
    def identities: Option[
      List[zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly]
    ]
    def nextToken: Option[PaginationKey]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getIdentities: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("identities", identities)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse
  ) extends zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly {
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.IdentityPoolId(value)
      )
    override val identities: Option[
      List[zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly]
    ] = scala
      .Option(impl.identities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.IdentityDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentity.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse
  ): zio.aws.cognitoidentity.model.ListIdentitiesResponse.ReadOnly =
    new Wrapper(impl)
}
