package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentity.model.primitives.{
  DateType,
  IdentityProviderName,
  IdentityId
}
import scala.jdk.CollectionConverters._
final case class IdentityDescription(
    identityId: Option[IdentityId] = None,
    logins: Option[Iterable[IdentityProviderName]] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription = {
    import IdentityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        logins.map(value =>
          value.map { item =>
            IdentityProviderName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logins)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly =
    zio.aws.cognitoidentity.model.IdentityDescription.wrap(buildAwsValue())
}
object IdentityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.IdentityDescription =
      zio.aws.cognitoidentity.model.IdentityDescription(
        identityId.map(value => value),
        logins.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def identityId: Option[IdentityId]
    def logins: Option[List[IdentityProviderName]]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getLogins: ZIO[Any, AwsError, List[IdentityProviderName]] =
      AwsError.unwrapOptionField("logins", logins)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
  ) extends zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly {
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitoidentity.model.primitives.IdentityId(value))
    override val logins: Option[List[IdentityProviderName]] = scala
      .Option(impl.logins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentity.model.primitives.IdentityProviderName(item)
        }.toList
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.cognitoidentity.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription
  ): zio.aws.cognitoidentity.model.IdentityDescription.ReadOnly = new Wrapper(
    impl
  )
}
