package zio.aws.cognitoidentity.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentity.model.primitives.{
  TagValueType,
  TagKeysType,
  ARNString
}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ARNString,
    tags: Map[TagKeysType, TagValueType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest
      .builder()
      .resourceArn(ARNString.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentity.model.TagResourceRequest.ReadOnly =
    zio.aws.cognitoidentity.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentity.model.TagResourceRequest =
      zio.aws.cognitoidentity.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ARNString
    def tags: Map[TagKeysType, TagValueType]
    def getResourceArn: ZIO[Any, Nothing, ARNString] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKeysType, TagValueType]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest
  ) extends zio.aws.cognitoidentity.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ARNString =
      zio.aws.cognitoidentity.model.primitives.ARNString(impl.resourceArn())
    override val tags: Map[TagKeysType, TagValueType] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.cognitoidentity.model.primitives.TagKeysType(
          key
        ) -> zio.aws.cognitoidentity.model.primitives.TagValueType(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest
  ): zio.aws.cognitoidentity.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
