package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTargetsResponse(
    targets: Optional[
      Iterable[zio.aws.codestarnotifications.model.TargetSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse = {
    import ListTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly =
    zio.aws.codestarnotifications.model.ListTargetsResponse
      .wrap(buildAwsValue())
}
object ListTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.ListTargetsResponse =
      zio.aws.codestarnotifications.model.ListTargetsResponse(
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def targets: Optional[
      List[zio.aws.codestarnotifications.model.TargetSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse
  ) extends zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly {
    override val targets: Optional[
      List[zio.aws.codestarnotifications.model.TargetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.TargetSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse
  ): zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
