package zio.aws.codestarnotifications
import zio.aws.codestarnotifications.model.CreateNotificationRuleResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.codestarnotifications.model.{
  UnsubscribeRequest,
  DescribeNotificationRuleRequest,
  ListEventTypesRequest,
  DeleteTargetRequest,
  ListTagsForResourceRequest,
  ListTargetsRequest,
  DeleteNotificationRuleRequest,
  CreateNotificationRuleRequest,
  ListNotificationRulesRequest,
  SubscribeRequest,
  UntagResourceRequest,
  UpdateNotificationRuleRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.codestarnotifications.model.{
  ListTargetsResponse,
  TargetSummary,
  EventTypeSummary,
  UpdateNotificationRuleResponse,
  UnsubscribeResponse,
  SubscribeResponse,
  ListTagsForResourceResponse,
  ListNotificationRulesResponse,
  UntagResourceResponse,
  NotificationRuleSummary,
  DeleteNotificationRuleResponse,
  DescribeNotificationRuleResponse,
  DeleteTargetResponse,
  ListEventTypesResponse,
  TagResourceResponse,
  CreateNotificationRuleResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.codestarnotifications.{
  CodestarNotificationsAsyncClientBuilder,
  CodestarNotificationsAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait CodestarNotifications extends AspectSupport[CodestarNotifications] {
  val api: CodestarNotificationsAsyncClient
  def deleteTarget(request: DeleteTargetRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.DeleteTargetResponse.ReadOnly
  ]
  def unsubscribe(request: UnsubscribeRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly
  ]
  def updateNotificationRule(request: UpdateNotificationRuleRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.UpdateNotificationRuleResponse.ReadOnly
  ]
  def listTargets(request: ListTargetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
  ]
  def listTargetsPaginated(request: ListTargetsRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly
  ]
  def listNotificationRules(request: ListNotificationRulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly
  ]
  def listNotificationRulesPaginated(request: ListNotificationRulesRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly
  ]
  def describeNotificationRule(request: DescribeNotificationRuleRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.UntagResourceResponse.ReadOnly
  ]
  def listEventTypes(request: ListEventTypesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
  ]
  def listEventTypesPaginated(request: ListEventTypesRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly
  ]
  def subscribe(request: SubscribeRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly
  ]
  def createNotificationRule(
      request: CreateNotificationRuleRequest
  ): IO[AwsError, ReadOnly]
  def deleteNotificationRule(request: DeleteNotificationRuleRequest): IO[
    AwsError,
    zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly
  ]
}
object CodestarNotifications {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodestarNotifications] =
    customized(identity)
  def customized(
      customization: CodestarNotificationsAsyncClientBuilder => CodestarNotificationsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodestarNotifications] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CodestarNotificationsAsyncClientBuilder => CodestarNotificationsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CodestarNotifications] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = CodestarNotificationsAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        CodestarNotificationsAsyncClient,
        CodestarNotificationsAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        CodestarNotificationsAsyncClient,
        CodestarNotificationsAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new CodestarNotificationsImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class CodestarNotificationsImpl[R](
      override val api: CodestarNotificationsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodestarNotifications
      with AwsServiceBase[R] {
    override val serviceName: String = "CodestarNotifications"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodestarNotificationsImpl[R1] =
      new CodestarNotificationsImpl(api, newAspect, r)
    def deleteTarget(request: DeleteTargetRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.DeleteTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest,
      DeleteTargetResponse
    ]("deleteTarget", api.deleteTarget)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.DeleteTargetResponse.wrap)
      .provideEnvironment(r)
    def unsubscribe(request: UnsubscribeRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest,
      UnsubscribeResponse
    ]("unsubscribe", api.unsubscribe)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.UnsubscribeResponse.wrap)
      .provideEnvironment(r)
    def updateNotificationRule(request: UpdateNotificationRuleRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.UpdateNotificationRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest,
      UpdateNotificationRuleResponse
    ]("updateNotificationRule", api.updateNotificationRule)(
      request.buildAwsValue()
    ).map(
      zio.aws.codestarnotifications.model.UpdateNotificationRuleResponse.wrap
    ).provideEnvironment(r)
    def listTargets(request: ListTargetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest,
      ListTargetsResponse,
      TargetSummary
    ](
      "listTargets",
      api.listTargets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.targets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.codestarnotifications.model.TargetSummary.wrap(item))
      .provideEnvironment(r)
    def listTargetsPaginated(request: ListTargetsRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest,
      ListTargetsResponse
    ]("listTargets", api.listTargets)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.ListTargetsResponse.wrap)
      .provideEnvironment(r)
    def listNotificationRules(request: ListNotificationRulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest,
      ListNotificationRulesResponse,
      NotificationRuleSummary
    ](
      "listNotificationRules",
      api.listNotificationRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.notificationRules().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codestarnotifications.model.NotificationRuleSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listNotificationRulesPaginated(
        request: ListNotificationRulesRequest
    ): IO[
      AwsError,
      zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest,
      ListNotificationRulesResponse
    ]("listNotificationRules", api.listNotificationRules)(
      request.buildAwsValue()
    ).map(
      zio.aws.codestarnotifications.model.ListNotificationRulesResponse.wrap
    ).provideEnvironment(r)
    def describeNotificationRule(request: DescribeNotificationRuleRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest,
      DescribeNotificationRuleResponse
    ]("describeNotificationRule", api.describeNotificationRule)(
      request.buildAwsValue()
    ).map(
      zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.wrap
    ).provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listEventTypes(request: ListEventTypesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest,
      ListEventTypesResponse,
      EventTypeSummary
    ](
      "listEventTypes",
      api.listEventTypes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventTypes().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codestarnotifications.model.EventTypeSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listEventTypesPaginated(request: ListEventTypesRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest,
      ListEventTypesResponse
    ]("listEventTypes", api.listEventTypes)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.ListEventTypesResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def subscribe(request: SubscribeRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest,
      SubscribeResponse
    ]("subscribe", api.subscribe)(request.buildAwsValue())
      .map(zio.aws.codestarnotifications.model.SubscribeResponse.wrap)
      .provideEnvironment(r)
    def createNotificationRule(
        request: CreateNotificationRuleRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest,
      CreateNotificationRuleResponse
    ]("createNotificationRule", api.createNotificationRule)(
      request.buildAwsValue()
    ).map(
      zio.aws.codestarnotifications.model.CreateNotificationRuleResponse.wrap
    ).provideEnvironment(r)
    def deleteNotificationRule(request: DeleteNotificationRuleRequest): IO[
      AwsError,
      zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest,
      DeleteNotificationRuleResponse
    ]("deleteNotificationRule", api.deleteNotificationRule)(
      request.buildAwsValue()
    ).map(
      zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.wrap
    ).provideEnvironment(r)
  }
  def deleteTarget(request: DeleteTargetRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.DeleteTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTarget(request))
  def unsubscribe(request: UnsubscribeRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unsubscribe(request))
  def updateNotificationRule(request: UpdateNotificationRuleRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.UpdateNotificationRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNotificationRule(request))
  def listTargets(request: ListTargetsRequest): ZStream[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTargets(request))
  def listTargetsPaginated(request: ListTargetsRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetsPaginated(request))
  def listNotificationRules(request: ListNotificationRulesRequest): ZStream[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotificationRules(request))
  def listNotificationRulesPaginated(
      request: ListNotificationRulesRequest
  ): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotificationRulesPaginated(request))
  def describeNotificationRule(request: DescribeNotificationRuleRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNotificationRule(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listEventTypes(request: ListEventTypesRequest): ZStream[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventTypes(request))
  def listEventTypesPaginated(request: ListEventTypesRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventTypesPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def subscribe(request: SubscribeRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.subscribe(request))
  def createNotificationRule(request: CreateNotificationRuleRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.createNotificationRule(request))
  def deleteNotificationRule(request: DeleteNotificationRuleRequest): ZIO[
    zio.aws.codestarnotifications.CodestarNotifications,
    AwsError,
    zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNotificationRule(request))
}
