package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(arn: NotificationRuleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.codestarnotifications.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.ListTagsForResourceRequest =
      zio.aws.codestarnotifications.model.ListTagsForResourceRequest(arn)
    def arn: NotificationRuleArn
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest
  ) extends zio.aws.codestarnotifications.model.ListTagsForResourceRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest
  ): zio.aws.codestarnotifications.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
