package zio.aws.codestarnotifications.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestarnotifications.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTargetsRequest(
    filters: Optional[
      Iterable[zio.aws.codestarnotifications.model.ListTargetsFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest = {
    import ListTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.ListTargetsRequest.ReadOnly =
    zio.aws.codestarnotifications.model.ListTargetsRequest.wrap(buildAwsValue())
}
object ListTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.ListTargetsRequest =
      zio.aws.codestarnotifications.model.ListTargetsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[
      List[zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
  ) extends zio.aws.codestarnotifications.model.ListTargetsRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.codestarnotifications.model.ListTargetsFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestarnotifications.model.ListTargetsFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest
  ): zio.aws.codestarnotifications.model.ListTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
