package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteNotificationRuleResponse(
    arn: Optional[NotificationRuleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse = {
    import DeleteNotificationRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse
      .builder()
      .optionallyWith(
        arn.map(value => NotificationRuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly =
    zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse
      .wrap(buildAwsValue())
}
object DeleteNotificationRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse =
      zio.aws.codestarnotifications.model
        .DeleteNotificationRuleResponse(arn.map(value => value))
    def arn: Optional[NotificationRuleArn]
    def getArn: ZIO[Any, AwsError, NotificationRuleArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse
  ) extends zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly {
    override val arn: Optional[NotificationRuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives
          .NotificationRuleArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse
  ): zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly =
    new Wrapper(impl)
}
