package zio.aws.codestarnotifications
import zio.aws.codestarnotifications.model.CreateNotificationRuleResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.codestarnotifications.model.{
  UnsubscribeRequest,
  DescribeNotificationRuleRequest,
  ListEventTypesRequest,
  DeleteTargetRequest,
  ListTagsForResourceRequest,
  ListTargetsRequest,
  DeleteNotificationRuleRequest,
  CreateNotificationRuleRequest,
  ListNotificationRulesRequest,
  SubscribeRequest,
  UntagResourceRequest,
  UpdateNotificationRuleRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsAsyncClient
import zio.stream.ZStream
object CodestarNotificationsMock extends Mock[CodestarNotifications] {
  object DeleteTarget
      extends Effect[
        DeleteTargetRequest,
        AwsError,
        zio.aws.codestarnotifications.model.DeleteTargetResponse.ReadOnly
      ]
  object Unsubscribe
      extends Effect[
        UnsubscribeRequest,
        AwsError,
        zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly
      ]
  object UpdateNotificationRule
      extends Effect[
        UpdateNotificationRuleRequest,
        AwsError,
        zio.aws.codestarnotifications.model.UpdateNotificationRuleResponse.ReadOnly
      ]
  object ListTargets
      extends Stream[
        ListTargetsRequest,
        AwsError,
        zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
      ]
  object ListTargetsPaginated
      extends Effect[
        ListTargetsRequest,
        AwsError,
        zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly
      ]
  object ListNotificationRules
      extends Stream[
        ListNotificationRulesRequest,
        AwsError,
        zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly
      ]
  object ListNotificationRulesPaginated
      extends Effect[
        ListNotificationRulesRequest,
        AwsError,
        zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly
      ]
  object DescribeNotificationRule
      extends Effect[
        DescribeNotificationRuleRequest,
        AwsError,
        zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codestarnotifications.model.UntagResourceResponse.ReadOnly
      ]
  object ListEventTypes
      extends Stream[
        ListEventTypesRequest,
        AwsError,
        zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
      ]
  object ListEventTypesPaginated
      extends Effect[
        ListEventTypesRequest,
        AwsError,
        zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codestarnotifications.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly
      ]
  object Subscribe
      extends Effect[
        SubscribeRequest,
        AwsError,
        zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly
      ]
  object CreateNotificationRule
      extends Effect[CreateNotificationRuleRequest, AwsError, ReadOnly]
  object DeleteNotificationRule
      extends Effect[
        DeleteNotificationRuleRequest,
        AwsError,
        zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodestarNotifications] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodestarNotifications] { rts =>
        zio.ZIO.succeed {
          new CodestarNotifications {
            val api: CodestarNotificationsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodestarNotifications = this
            def deleteTarget(request: DeleteTargetRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.DeleteTargetResponse.ReadOnly
            ] = proxy(DeleteTarget, request)
            def unsubscribe(request: UnsubscribeRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly
            ] = proxy(Unsubscribe, request)
            def updateNotificationRule(
                request: UpdateNotificationRuleRequest
            ): IO[
              AwsError,
              zio.aws.codestarnotifications.model.UpdateNotificationRuleResponse.ReadOnly
            ] = proxy(UpdateNotificationRule, request)
            def listTargets(request: ListTargetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codestarnotifications.model.TargetSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTargets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTargetsPaginated(request: ListTargetsRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.ListTargetsResponse.ReadOnly
            ] = proxy(ListTargetsPaginated, request)
            def listNotificationRules(
                request: ListNotificationRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codestarnotifications.model.NotificationRuleSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotificationRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotificationRulesPaginated(
                request: ListNotificationRulesRequest
            ): IO[
              AwsError,
              zio.aws.codestarnotifications.model.ListNotificationRulesResponse.ReadOnly
            ] = proxy(ListNotificationRulesPaginated, request)
            def describeNotificationRule(
                request: DescribeNotificationRuleRequest
            ): IO[
              AwsError,
              zio.aws.codestarnotifications.model.DescribeNotificationRuleResponse.ReadOnly
            ] = proxy(DescribeNotificationRule, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listEventTypes(request: ListEventTypesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventTypes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventTypesPaginated(request: ListEventTypesRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.ListEventTypesResponse.ReadOnly
            ] = proxy(ListEventTypesPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def subscribe(request: SubscribeRequest): IO[
              AwsError,
              zio.aws.codestarnotifications.model.SubscribeResponse.ReadOnly
            ] = proxy(Subscribe, request)
            def createNotificationRule(
                request: CreateNotificationRuleRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateNotificationRule, request)
            def deleteNotificationRule(
                request: DeleteNotificationRuleRequest
            ): IO[
              AwsError,
              zio.aws.codestarnotifications.model.DeleteNotificationRuleResponse.ReadOnly
            ] = proxy(DeleteNotificationRule, request)
          }
        }
      }
    }
  }
}
