package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.NotificationRuleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UnsubscribeResponse(arn: NotificationRuleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse = {
    import UnsubscribeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly =
    zio.aws.codestarnotifications.model.UnsubscribeResponse
      .wrap(buildAwsValue())
}
object UnsubscribeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.UnsubscribeResponse =
      zio.aws.codestarnotifications.model.UnsubscribeResponse(arn)
    def arn: NotificationRuleArn
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse
  ) extends zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse
  ): zio.aws.codestarnotifications.model.UnsubscribeResponse.ReadOnly =
    new Wrapper(impl)
}
