package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  ResourceType,
  EventTypeName,
  ServiceName,
  EventTypeId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventTypeSummary(
    eventTypeId: Optional[EventTypeId] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent,
    eventTypeName: Optional[EventTypeName] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary = {
    import EventTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary
      .builder()
      .optionallyWith(
        eventTypeId.map(value => EventTypeId.unwrap(value): java.lang.String)
      )(_.eventTypeId)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        eventTypeName.map(value =>
          EventTypeName.unwrap(value): java.lang.String
        )
      )(_.eventTypeName)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly =
    zio.aws.codestarnotifications.model.EventTypeSummary.wrap(buildAwsValue())
}
object EventTypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.EventTypeSummary =
      zio.aws.codestarnotifications.model.EventTypeSummary(
        eventTypeId.map(value => value),
        serviceName.map(value => value),
        eventTypeName.map(value => value),
        resourceType.map(value => value)
      )
    def eventTypeId: Optional[EventTypeId]
    def serviceName: Optional[ServiceName]
    def eventTypeName: Optional[EventTypeName]
    def resourceType: Optional[ResourceType]
    def getEventTypeId: ZIO[Any, AwsError, EventTypeId] =
      AwsError.unwrapOptionField("eventTypeId", eventTypeId)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getEventTypeName: ZIO[Any, AwsError, EventTypeName] =
      AwsError.unwrapOptionField("eventTypeName", eventTypeName)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary
  ) extends zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly {
    override val eventTypeId: Optional[EventTypeId] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTypeId())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.EventTypeId(value)
      )
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.ServiceName(value)
      )
    override val eventTypeName: Optional[EventTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTypeName())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.EventTypeName(value)
      )
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value =>
        zio.aws.codestarnotifications.model.primitives.ResourceType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary
  ): zio.aws.codestarnotifications.model.EventTypeSummary.ReadOnly =
    new Wrapper(impl)
}
