package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  NotificationRuleResource,
  ClientRequestToken,
  TagValue,
  EventTypeId,
  NotificationRuleName,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNotificationRuleRequest(
    name: NotificationRuleName,
    eventTypeIds: Iterable[EventTypeId],
    resource: NotificationRuleResource,
    targets: Iterable[zio.aws.codestarnotifications.model.Target],
    detailType: zio.aws.codestarnotifications.model.DetailType,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    status: Optional[
      zio.aws.codestarnotifications.model.NotificationRuleStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest = {
    import CreateNotificationRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest
      .builder()
      .name(NotificationRuleName.unwrap(name): java.lang.String)
      .eventTypeIds(eventTypeIds.map { item =>
        EventTypeId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .resource(NotificationRuleResource.unwrap(resource): java.lang.String)
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .detailType(detailType.unwrap)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.CreateNotificationRuleRequest.ReadOnly =
    zio.aws.codestarnotifications.model.CreateNotificationRuleRequest
      .wrap(buildAwsValue())
}
object CreateNotificationRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codestarnotifications.model.CreateNotificationRuleRequest =
      zio.aws.codestarnotifications.model.CreateNotificationRuleRequest(
        name,
        eventTypeIds,
        resource,
        targets.map { item =>
          item.asEditable
        },
        detailType,
        clientRequestToken.map(value => value),
        tags.map(value => value),
        status.map(value => value)
      )
    def name: NotificationRuleName
    def eventTypeIds: List[EventTypeId]
    def resource: NotificationRuleResource
    def targets: List[zio.aws.codestarnotifications.model.Target.ReadOnly]
    def detailType: zio.aws.codestarnotifications.model.DetailType
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def status
        : Optional[zio.aws.codestarnotifications.model.NotificationRuleStatus]
    def getName: ZIO[Any, Nothing, NotificationRuleName] = ZIO.succeed(name)
    def getEventTypeIds: ZIO[Any, Nothing, List[EventTypeId]] =
      ZIO.succeed(eventTypeIds)
    def getResource: ZIO[Any, Nothing, NotificationRuleResource] =
      ZIO.succeed(resource)
    def getTargets: ZIO[Any, Nothing, List[
      zio.aws.codestarnotifications.model.Target.ReadOnly
    ]] = ZIO.succeed(targets)
    def getDetailType
        : ZIO[Any, Nothing, zio.aws.codestarnotifications.model.DetailType] =
      ZIO.succeed(detailType)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codestarnotifications.model.NotificationRuleStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest
  ) extends zio.aws.codestarnotifications.model.CreateNotificationRuleRequest.ReadOnly {
    override val name: NotificationRuleName =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleName(impl.name())
    override val eventTypeIds: List[EventTypeId] = impl
      .eventTypeIds()
      .asScala
      .map { item =>
        zio.aws.codestarnotifications.model.primitives.EventTypeId(item)
      }
      .toList
    override val resource: NotificationRuleResource =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleResource(impl.resource())
    override val targets
        : List[zio.aws.codestarnotifications.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.codestarnotifications.model.Target.wrap(item)
      }
      .toList
    override val detailType: zio.aws.codestarnotifications.model.DetailType =
      zio.aws.codestarnotifications.model.DetailType.wrap(impl.detailType())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codestarnotifications.model.primitives
            .ClientRequestToken(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestarnotifications.model.primitives.TagKey(
              key
            ) -> zio.aws.codestarnotifications.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val status
        : Optional[zio.aws.codestarnotifications.model.NotificationRuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codestarnotifications.model.NotificationRuleStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest
  ): zio.aws.codestarnotifications.model.CreateNotificationRuleRequest.ReadOnly =
    new Wrapper(impl)
}
