package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{
  TagKey,
  NotificationRuleArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    arn: NotificationRuleArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest
      .builder()
      .arn(NotificationRuleArn.unwrap(arn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.UntagResourceRequest.ReadOnly =
    zio.aws.codestarnotifications.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.UntagResourceRequest =
      zio.aws.codestarnotifications.model.UntagResourceRequest(arn, tagKeys)
    def arn: NotificationRuleArn
    def tagKeys: List[TagKey]
    def getArn: ZIO[Any, Nothing, NotificationRuleArn] = ZIO.succeed(arn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest
  ) extends zio.aws.codestarnotifications.model.UntagResourceRequest.ReadOnly {
    override val arn: NotificationRuleArn =
      zio.aws.codestarnotifications.model.primitives
        .NotificationRuleArn(impl.arn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.codestarnotifications.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest
  ): zio.aws.codestarnotifications.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
