package zio.aws.codestarnotifications.model
import zio.ZIO
import zio.aws.codestarnotifications.model.primitives.{TagValue, TagKey}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagResourceResponse(
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse = {
    import TagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly =
    zio.aws.codestarnotifications.model.TagResourceResponse
      .wrap(buildAwsValue())
}
object TagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestarnotifications.model.TagResourceResponse =
      zio.aws.codestarnotifications.model
        .TagResourceResponse(tags.map(value => value))
    def tags: Option[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse
  ) extends zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly {
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestarnotifications.model.primitives.TagKey(
              key
            ) -> zio.aws.codestarnotifications.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse
  ): zio.aws.codestarnotifications.model.TagResourceResponse.ReadOnly =
    new Wrapper(impl)
}
